/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimOperation;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimOperation
extends ScimOperation {
    private final String op;
    @Nullable
    private final String path;
    @Nullable
    private final JsonNode value;

    private ImmutableScimOperation(String op, @Nullable String path, @Nullable JsonNode value) {
        this.op = Objects.requireNonNull(op, "op");
        this.path = path;
        this.value = value;
    }

    private ImmutableScimOperation(ImmutableScimOperation original, String op, @Nullable String path, @Nullable JsonNode value) {
        this.op = op;
        this.path = path;
        this.value = value;
    }

    @Override
    @JsonProperty
    public String getOp() {
        return this.op;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty
    @Nullable
    public JsonNode getValue() {
        return this.value;
    }

    public final ImmutableScimOperation withOp(String value) {
        if (this.op.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "op");
        return new ImmutableScimOperation(this, newValue, this.path, this.value);
    }

    public final ImmutableScimOperation withPath(@Nullable String value) {
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableScimOperation(this, this.op, value, this.value);
    }

    public final ImmutableScimOperation withValue(@Nullable JsonNode value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableScimOperation(this, this.op, this.path, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimOperation && this.equalTo((ImmutableScimOperation)another);
    }

    private boolean equalTo(ImmutableScimOperation another) {
        return this.op.equals(another.op) && Objects.equals(this.path, another.path) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.op.hashCode();
        h = h * 17 + Objects.hashCode(this.path);
        h = h * 17 + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "ScimOperation{op=" + this.op + ", path=" + this.path + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimOperation fromJson(Json json) {
        Builder builder = ImmutableScimOperation.builder();
        if (json.op != null) {
            builder.withOp(json.op);
        }
        if (json.path != null) {
            builder.withPath(json.path);
        }
        if (json.value != null) {
            builder.withValue(json.value);
        }
        return builder.build();
    }

    public static ImmutableScimOperation of(String op, @Nullable String path, @Nullable JsonNode value) {
        return new ImmutableScimOperation(op, path, value);
    }

    public static ImmutableScimOperation copyOf(ScimOperation instance) {
        if (instance instanceof ImmutableScimOperation) {
            return (ImmutableScimOperation)instance;
        }
        return ImmutableScimOperation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OP = 1L;
        private long initBits = 1L;
        @Nullable
        private String op;
        @Nullable
        private String path;
        @Nullable
        private JsonNode value;

        private Builder() {
        }

        public final Builder from(ScimOperation instance) {
            JsonNode valueValue;
            Objects.requireNonNull(instance, "instance");
            this.withOp(instance.getOp());
            String pathValue = instance.getPath();
            if (pathValue != null) {
                this.withPath(pathValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.withValue(valueValue);
            }
            return this;
        }

        public final Builder withOp(String op) {
            this.op = Objects.requireNonNull(op, "op");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder withPath(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder withValue(@Nullable JsonNode value) {
            this.value = value;
            return this;
        }

        public ImmutableScimOperation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScimOperation(null, this.op, this.path, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("op");
            }
            return "Cannot build ScimOperation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimOperation {
        @Nullable
        String op;
        @Nullable
        String path;
        @Nullable
        JsonNode value;

        Json() {
        }

        @JsonProperty
        public void setOp(String op) {
            this.op = op;
        }

        @JsonProperty
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty
        public void setValue(@Nullable JsonNode value) {
            this.value = value;
        }

        @Override
        public String getOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

