/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimName;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimName
extends ScimName {
    @Nullable
    private final String familyName;
    @Nullable
    private final String givenName;
    @Nullable
    private final String formattedName;

    private ImmutableScimName(@Nullable String familyName, @Nullable String givenName, @Nullable String formattedName) {
        this.familyName = familyName;
        this.givenName = givenName;
        this.formattedName = formattedName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    @JsonProperty(value="formatted")
    @Nullable
    public String getFormattedName() {
        return this.formattedName;
    }

    public final ImmutableScimName withFamilyName(@Nullable String value) {
        if (Objects.equals(this.familyName, value)) {
            return this;
        }
        return new ImmutableScimName(value, this.givenName, this.formattedName);
    }

    public final ImmutableScimName withGivenName(@Nullable String value) {
        if (Objects.equals(this.givenName, value)) {
            return this;
        }
        return new ImmutableScimName(this.familyName, value, this.formattedName);
    }

    public final ImmutableScimName withFormattedName(@Nullable String value) {
        if (Objects.equals(this.formattedName, value)) {
            return this;
        }
        return new ImmutableScimName(this.familyName, this.givenName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimName && this.equalTo((ImmutableScimName)another);
    }

    private boolean equalTo(ImmutableScimName another) {
        return Objects.equals(this.familyName, another.familyName) && Objects.equals(this.givenName, another.givenName) && Objects.equals(this.formattedName, another.formattedName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.familyName);
        h = h * 17 + Objects.hashCode(this.givenName);
        h = h * 17 + Objects.hashCode(this.formattedName);
        return h;
    }

    public String toString() {
        return "ScimName{familyName=" + this.familyName + ", givenName=" + this.givenName + ", formattedName=" + this.formattedName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimName fromJson(Json json) {
        Builder builder = ImmutableScimName.builder();
        if (json.familyName != null) {
            builder.withFamilyName(json.familyName);
        }
        if (json.givenName != null) {
            builder.withGivenName(json.givenName);
        }
        if (json.formattedName != null) {
            builder.withFormattedName(json.formattedName);
        }
        return builder.build();
    }

    public static ImmutableScimName of(@Nullable String familyName, @Nullable String givenName, @Nullable String formattedName) {
        return new ImmutableScimName(familyName, givenName, formattedName);
    }

    public static ImmutableScimName copyOf(ScimName instance) {
        if (instance instanceof ImmutableScimName) {
            return (ImmutableScimName)instance;
        }
        return ImmutableScimName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String familyName;
        @Nullable
        private String givenName;
        @Nullable
        private String formattedName;

        private Builder() {
        }

        public final Builder from(ScimName instance) {
            String formattedNameValue;
            String givenNameValue;
            Objects.requireNonNull(instance, "instance");
            String familyNameValue = instance.getFamilyName();
            if (familyNameValue != null) {
                this.withFamilyName(familyNameValue);
            }
            if ((givenNameValue = instance.getGivenName()) != null) {
                this.withGivenName(givenNameValue);
            }
            if ((formattedNameValue = instance.getFormattedName()) != null) {
                this.withFormattedName(formattedNameValue);
            }
            return this;
        }

        public final Builder withFamilyName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        public final Builder withGivenName(@Nullable String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final Builder withFormattedName(@Nullable String formattedName) {
            this.formattedName = formattedName;
            return this;
        }

        public ImmutableScimName build() {
            return new ImmutableScimName(this.familyName, this.givenName, this.formattedName);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimName {
        @Nullable
        String familyName;
        @Nullable
        String givenName;
        @Nullable
        String formattedName;

        Json() {
        }

        @JsonProperty
        public void setFamilyName(@Nullable String familyName) {
            this.familyName = familyName;
        }

        @JsonProperty
        public void setGivenName(@Nullable String givenName) {
            this.givenName = givenName;
        }

        @JsonProperty(value="formatted")
        public void setFormattedName(@Nullable String formattedName) {
            this.formattedName = formattedName;
        }

        @Override
        public String getFamilyName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGivenName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormattedName() {
            throw new UnsupportedOperationException();
        }
    }
}

