/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimGroupMember;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimGroupMember
extends ScimGroupMember {
    private final String value;
    @Nullable
    private final String display;
    @Nullable
    private final String ref;

    private ImmutableScimGroupMember(String value) {
        this.value = Objects.requireNonNull(value, "value");
        this.display = null;
        this.ref = null;
    }

    private ImmutableScimGroupMember(String value, @Nullable String display, @Nullable String ref) {
        this.value = value;
        this.display = display;
        this.ref = ref;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @Override
    @JsonProperty(value="$ref")
    @Nullable
    public String getRef() {
        return this.ref;
    }

    public final ImmutableScimGroupMember withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return new ImmutableScimGroupMember(newValue, this.display, this.ref);
    }

    public final ImmutableScimGroupMember withDisplay(@Nullable String value) {
        if (Objects.equals(this.display, value)) {
            return this;
        }
        return new ImmutableScimGroupMember(this.value, value, this.ref);
    }

    public final ImmutableScimGroupMember withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableScimGroupMember(this.value, this.display, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimGroupMember && this.equalTo((ImmutableScimGroupMember)another);
    }

    private boolean equalTo(ImmutableScimGroupMember another) {
        return this.value.equals(another.value) && Objects.equals(this.display, another.display) && Objects.equals(this.ref, another.ref);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value.hashCode();
        h = h * 17 + Objects.hashCode(this.display);
        h = h * 17 + Objects.hashCode(this.ref);
        return h;
    }

    public String toString() {
        return "ScimGroupMember{value=" + this.value + ", display=" + this.display + ", ref=" + this.ref + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimGroupMember fromJson(Json json) {
        Builder builder = ImmutableScimGroupMember.builder();
        if (json.value != null) {
            builder.withValue(json.value);
        }
        if (json.display != null) {
            builder.withDisplay(json.display);
        }
        if (json.ref != null) {
            builder.withRef(json.ref);
        }
        return builder.build();
    }

    public static ImmutableScimGroupMember of(String value) {
        return new ImmutableScimGroupMember(value);
    }

    public static ImmutableScimGroupMember copyOf(ScimGroupMember instance) {
        if (instance instanceof ImmutableScimGroupMember) {
            return (ImmutableScimGroupMember)instance;
        }
        return ImmutableScimGroupMember.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;
        @Nullable
        private String display;
        @Nullable
        private String ref;

        private Builder() {
        }

        public final Builder from(ScimGroupMember instance) {
            String refValue;
            Objects.requireNonNull(instance, "instance");
            this.withValue(instance.getValue());
            String displayValue = instance.getDisplay();
            if (displayValue != null) {
                this.withDisplay(displayValue);
            }
            if ((refValue = instance.getRef()) != null) {
                this.withRef(refValue);
            }
            return this;
        }

        public final Builder withValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder withDisplay(@Nullable String display) {
            this.display = display;
            return this;
        }

        public final Builder withRef(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        public ImmutableScimGroupMember build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScimGroupMember(this.value, this.display, this.ref);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ScimGroupMember, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimGroupMember {
        @Nullable
        String value;
        @Nullable
        String display;
        @Nullable
        String ref;

        Json() {
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setDisplay(@Nullable String display) {
            this.display = display;
        }

        @JsonProperty(value="$ref")
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRef() {
            throw new UnsupportedOperationException();
        }
    }
}

