/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimGroup;
import com.atlassian.idp.model.ScimGroupListResponse;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimGroupListResponse
extends ScimGroupListResponse {
    @Nullable
    private final Set<String> schemas;
    @Nullable
    private final Integer totalResults;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final Integer itemsPerPage;
    @Nullable
    private final List<ScimGroup> resources;

    private ImmutableScimGroupListResponse(Builder builder) {
        this.totalResults = builder.totalResults;
        this.startIndex = builder.startIndex;
        this.itemsPerPage = builder.itemsPerPage;
        List<Object> list = this.resources = builder.resources == null ? null : ImmutableScimGroupListResponse.createUnmodifiableList(true, builder.resources);
        this.schemas = builder.schemasIsSet() ? (builder.schemas == null ? null : ImmutableScimGroupListResponse.createUnmodifiableSet(builder.schemas)) : (super.getSchemas() == null ? null : ImmutableScimGroupListResponse.createUnmodifiableSet(ImmutableScimGroupListResponse.createSafeList(super.getSchemas(), true, false)));
    }

    private ImmutableScimGroupListResponse(@Nullable Set<String> schemas, @Nullable Integer totalResults, @Nullable Integer startIndex, @Nullable Integer itemsPerPage, @Nullable List<ScimGroup> resources) {
        this.schemas = schemas;
        this.totalResults = totalResults;
        this.startIndex = startIndex;
        this.itemsPerPage = itemsPerPage;
        this.resources = resources;
    }

    @Override
    @JsonProperty
    @Nullable
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    @JsonProperty(value="Resources")
    @Nullable
    public List<ScimGroup> getResources() {
        return this.resources;
    }

    public final ImmutableScimGroupListResponse withSchemas(String ... elements) {
        if (elements == null) {
            return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(null, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimGroupListResponse.createUnmodifiableSet(ImmutableScimGroupListResponse.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(newValue, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimGroupListResponse withSchemas(@Nullable Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableScimGroupListResponse.createUnmodifiableSet(ImmutableScimGroupListResponse.createSafeList(elements, true, false));
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(newValue, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimGroupListResponse withTotalResults(@Nullable Integer value) {
        if (Objects.equals(this.totalResults, value)) {
            return this;
        }
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, value, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimGroupListResponse withStartIndex(@Nullable Integer value) {
        if (Objects.equals(this.startIndex, value)) {
            return this;
        }
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, this.totalResults, value, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimGroupListResponse withItemsPerPage(@Nullable Integer value) {
        if (Objects.equals(this.itemsPerPage, value)) {
            return this;
        }
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, this.totalResults, this.startIndex, value, this.resources));
    }

    public final ImmutableScimGroupListResponse withResources(ScimGroup ... elements) {
        if (elements == null) {
            return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, null));
        }
        List<ScimGroup> newValue = Arrays.asList(elements) == null ? null : ImmutableScimGroupListResponse.createUnmodifiableList(false, ImmutableScimGroupListResponse.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, newValue));
    }

    public final ImmutableScimGroupListResponse withResources(@Nullable Iterable<? extends ScimGroup> elements) {
        if (this.resources == elements) {
            return this;
        }
        List<ScimGroup> newValue = elements == null ? null : ImmutableScimGroupListResponse.createUnmodifiableList(false, ImmutableScimGroupListResponse.createSafeList(elements, true, false));
        return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimGroupListResponse && this.equalTo((ImmutableScimGroupListResponse)another);
    }

    private boolean equalTo(ImmutableScimGroupListResponse another) {
        return Objects.equals(this.schemas, another.schemas) && Objects.equals(this.totalResults, another.totalResults) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.itemsPerPage, another.itemsPerPage) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.schemas);
        h = h * 17 + Objects.hashCode(this.totalResults);
        h = h * 17 + Objects.hashCode(this.startIndex);
        h = h * 17 + Objects.hashCode(this.itemsPerPage);
        h = h * 17 + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "ScimGroupListResponse{schemas=" + this.schemas + ", totalResults=" + this.totalResults + ", startIndex=" + this.startIndex + ", itemsPerPage=" + this.itemsPerPage + ", resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimGroupListResponse fromJson(Json json) {
        Builder builder = ImmutableScimGroupListResponse.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.totalResults != null) {
            builder.withTotalResults(json.totalResults);
        }
        if (json.startIndex != null) {
            builder.withStartIndex(json.startIndex);
        }
        if (json.itemsPerPage != null) {
            builder.withItemsPerPage(json.itemsPerPage);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    private static ImmutableScimGroupListResponse validate(ImmutableScimGroupListResponse instance) {
        instance.checkSchemas();
        return instance;
    }

    public static ImmutableScimGroupListResponse copyOf(ScimGroupListResponse instance) {
        if (instance instanceof ImmutableScimGroupListResponse) {
            return (ImmutableScimGroupListResponse)instance;
        }
        return ImmutableScimGroupListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = null;
        @Nullable
        private Integer totalResults;
        @Nullable
        private Integer startIndex;
        @Nullable
        private Integer itemsPerPage;
        private List<ScimGroup> resources = null;

        private Builder() {
        }

        public final Builder from(ScimGroupListResponse instance) {
            List resourcesValue;
            Integer itemsPerPageValue;
            Integer startIndexValue;
            Integer totalResultsValue;
            Objects.requireNonNull(instance, "instance");
            Set<String> schemasValue = instance.getSchemas();
            if (schemasValue != null) {
                this.addAllSchemas(schemasValue);
            }
            if ((totalResultsValue = instance.getTotalResults()) != null) {
                this.withTotalResults(totalResultsValue);
            }
            if ((startIndexValue = instance.getStartIndex()) != null) {
                this.withStartIndex(startIndexValue);
            }
            if ((itemsPerPageValue = instance.getItemsPerPage()) != null) {
                this.withItemsPerPage(itemsPerPageValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        public final Builder addSchemas(String element) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.schemas = null;
                this.optBits |= 1L;
                return this;
            }
            this.schemas = new ArrayList<String>();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            Objects.requireNonNull(elements, "schemas element");
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withTotalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public final Builder withStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Builder withItemsPerPage(@Nullable Integer itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        public final Builder addResources(ScimGroup element) {
            if (this.resources == null) {
                this.resources = new ArrayList<ScimGroup>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder addResources(ScimGroup ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<ScimGroup>();
            }
            for (ScimGroup element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder withResources(@Nullable Iterable<? extends ScimGroup> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<ScimGroup>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends ScimGroup> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<ScimGroup>();
            }
            for (ScimGroup scimGroup : elements) {
                this.resources.add(Objects.requireNonNull(scimGroup, "resources element"));
            }
            return this;
        }

        public ImmutableScimGroupListResponse build() {
            return ImmutableScimGroupListResponse.validate(new ImmutableScimGroupListResponse(this));
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimGroupListResponse {
        Set<String> schemas = null;
        boolean schemasIsSet;
        @Nullable
        Integer totalResults;
        @Nullable
        Integer startIndex;
        @Nullable
        Integer itemsPerPage;
        List<ScimGroup> resources = null;

        Json() {
        }

        @JsonProperty
        public void setSchemas(@Nullable Set<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty
        public void setTotalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
        }

        @JsonProperty
        public void setStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
        }

        @JsonProperty
        public void setItemsPerPage(@Nullable Integer itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
        }

        @JsonProperty(value="Resources")
        public void setResources(@Nullable List<ScimGroup> resources) {
            this.resources = resources;
        }

        @Override
        public Set<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getItemsPerPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimGroup> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

