/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimAttribute;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimAttribute
extends ScimAttribute {
    private final String key;
    private final String value;

    private ImmutableScimAttribute(String key, String value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableScimAttribute(ImmutableScimAttribute original, String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public final ImmutableScimAttribute withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "key");
        return new ImmutableScimAttribute(this, newValue, this.value);
    }

    public final ImmutableScimAttribute withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return new ImmutableScimAttribute(this, this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimAttribute && this.equalTo((ImmutableScimAttribute)another);
    }

    private boolean equalTo(ImmutableScimAttribute another) {
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.key.hashCode();
        h = h * 17 + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ScimAttribute{key=" + this.key + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimAttribute fromJson(Json json) {
        Builder builder = ImmutableScimAttribute.builder();
        if (json.key != null) {
            builder.withKey(json.key);
        }
        if (json.value != null) {
            builder.withValue(json.value);
        }
        return builder.build();
    }

    public static ImmutableScimAttribute of(String key, String value) {
        return new ImmutableScimAttribute(key, value);
    }

    public static ImmutableScimAttribute copyOf(ScimAttribute instance) {
        if (instance instanceof ImmutableScimAttribute) {
            return (ImmutableScimAttribute)instance;
        }
        return ImmutableScimAttribute.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(ScimAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.withKey(instance.getKey());
            this.withValue(instance.getValue());
            return this;
        }

        public final Builder withKey(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder withValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableScimAttribute build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScimAttribute(null, this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ScimAttribute, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimAttribute {
        @Nullable
        String key;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

