/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import com.atlassian.httpclient.api.factory.Host;
import com.atlassian.httpclient.api.factory.Scheme;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidedProxyConfig
extends ProxyConfig {
    private static final Logger log = LoggerFactory.getLogger(ProvidedProxyConfig.class);
    private static final Iterable<String> SUPPORTED_SCHEMAS = Lists.newArrayList((Object[])new String[]{"http", "https"});
    private final Map<String, HttpHost> proxyHostMap;
    private final Map<String, List<String>> nonProxyHosts;

    public ProvidedProxyConfig(@Nonnull Map<Scheme, Host> proxyHostMap, @Nonnull Map<Scheme, List<String>> nonProxyHosts) {
        Preconditions.checkNotNull(proxyHostMap);
        Preconditions.checkNotNull(nonProxyHosts);
        this.proxyHostMap = new HashMap<String, HttpHost>(proxyHostMap.size());
        for (Scheme s : proxyHostMap.keySet()) {
            Host h = proxyHostMap.get((Object)s);
            this.proxyHostMap.put(s.schemeName(), new HttpHost(h.getHost(), h.getPort()));
        }
        this.nonProxyHosts = new HashMap<String, List<String>>(nonProxyHosts.size());
        for (Scheme s : nonProxyHosts.keySet()) {
            List<String> nonProxyHostList = nonProxyHosts.get((Object)s);
            if (nonProxyHostList == null) continue;
            this.nonProxyHosts.put(s.schemeName(), (List<String>)ImmutableList.copyOf(nonProxyHostList));
        }
    }

    @Override
    Iterable<HttpHost> getProxyHosts() {
        Iterable httpHosts = Iterables.transform(SUPPORTED_SCHEMAS, (Function)new Function<String, Option<HttpHost>>(){

            public Option<HttpHost> apply(String schema) {
                return Option.option(ProvidedProxyConfig.this.proxyHostMap.get(schema));
            }
        });
        return Options.flatten((Iterable)Options.filterNone((Iterable)httpHosts));
    }

    @Override
    public Iterable<ProxyConfig.AuthenticationInfo> getAuthenticationInfo() {
        log.info("Authentication info not supported for ProvidedProxyConfig");
        return Collections.emptyList();
    }
}

