/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.proxy.ProvidedProxyConfig;
import com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import com.atlassian.httpclient.apache.httpcomponents.proxy.SystemPropertiesProxyConfig;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import org.apache.http.HttpHost;

public class ProxyConfigFactory {
    public static Option<HttpHost> getProxyHost(HttpClientOptions options) {
        return (Option)ProxyConfigFactory.getProxyConfig(options).fold((Supplier)new Supplier<Option<HttpHost>>(){

            public Option<HttpHost> get() {
                return Option.none();
            }
        }, (Function)new Function<ProxyConfig, Option<HttpHost>>(){

            public Option<HttpHost> apply(ProxyConfig proxyConfig) {
                return proxyConfig.getProxyHost();
            }
        });
    }

    public static Iterable<ProxyConfig.AuthenticationInfo> getProxyAuthentication(HttpClientOptions options) {
        return (Iterable)ProxyConfigFactory.getProxyConfig(options).fold((Supplier)new Supplier<Iterable<ProxyConfig.AuthenticationInfo>>(){

            public Iterable<ProxyConfig.AuthenticationInfo> get() {
                return Lists.newLinkedList();
            }
        }, (Function)new Function<ProxyConfig, Iterable<ProxyConfig.AuthenticationInfo>>(){

            public Iterable<ProxyConfig.AuthenticationInfo> apply(ProxyConfig proxyConfig) {
                return proxyConfig.getAuthenticationInfo();
            }
        });
    }

    private static Option<ProxyConfig> getProxyConfig(HttpClientOptions options) {
        Option config;
        switch (options.getProxyOptions().getProxyMode()) {
            case SYSTEM_PROPERTIES: {
                config = Option.some((Object)new SystemPropertiesProxyConfig());
                break;
            }
            case CONFIGURED: {
                config = Option.some((Object)new ProvidedProxyConfig(options.getProxyOptions().getProxyHosts(), options.getProxyOptions().getNonProxyHosts()));
                break;
            }
            default: {
                config = Option.none();
            }
        }
        return config;
    }
}

