/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.HttpClientProxyConfig;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.ProxyConfigFactory;
import com.atlassian.httpclient.apache.httpcomponents.ProxyRoutePlanner;
import com.atlassian.httpclient.apache.httpcomponents.RequestEntityEffect;
import com.atlassian.httpclient.apache.httpcomponents.SettableFuturePromiseHttpPromiseAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorage;
import com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorageImpl;
import com.atlassian.httpclient.apache.httpcomponents.cache.LoggingHttpCacheStorage;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.scheme.AsyncScheme;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import org.apache.http.nio.conn.ssl.SSLLayeringStrategy;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class ApacheAsyncHttpClient<C>
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Supplier<String> httpClientVersion = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            return MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api");
        }
    });
    private final Function<Object, Void> eventConsumer;
    private final Supplier<String> applicationName;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final HttpAsyncClient httpClient;
    private final HttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventConsumer, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        this(new DefaultApplicationNameSupplier(applicationProperties), new EventConsumerFunction(eventConsumer), threadLocalContextManager, options);
    }

    public ApacheAsyncHttpClient(String applicationName) {
        this(applicationName, new HttpClientOptions());
    }

    public ApacheAsyncHttpClient(String applicationName, HttpClientOptions options) {
        this((Supplier<String>)Suppliers.ofInstance((Object)applicationName), (Function<Object, Void>)Functions.constant((Object)null), new NoOpThreadLocalContextManager(), options);
    }

    public ApacheAsyncHttpClient(Supplier<String> applicationName, Function<Object, Void> eventConsumer, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        DefaultHttpAsyncClient client;
        this.eventConsumer = (Function)Preconditions.checkNotNull(eventConsumer);
        this.applicationName = (Supplier)Preconditions.checkNotNull(applicationName);
        this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull(threadLocalContextManager);
        this.httpClientOptions = (HttpClientOptions)Preconditions.checkNotNull((Object)options);
        try {
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(options.getIoThreadCount());
            ioReactorConfig.setSelectInterval(options.getIoSelectInterval());
            ioReactorConfig.setInterestOpQueued(true);
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                @Override
                public boolean handle(IOException ex) {
                    ApacheAsyncHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                @Override
                public boolean handle(RuntimeException ex) {
                    ApacheAsyncHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            final PoolingClientAsyncConnectionManager connmgr = new PoolingClientAsyncConnectionManager(reactor, this.getAsyncSchemeRegistryFactory(options.trustSelfSignedCertificates()), options.getConnectionPoolTimeToLive(), options.getLeaseTimeout(), TimeUnit.MILLISECONDS){

                @Override
                protected void finalize() throws Throwable {
                }
            };
            connmgr.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            client = new DefaultHttpAsyncClient(connmgr);
            Option<HttpClientProxyConfig> optProxyConfig = this.getProxyConfig(options);
            optProxyConfig.foreach((Effect)new Effect<HttpClientProxyConfig>(){

                public void apply(HttpClientProxyConfig httpClientProxyConfig) {
                    httpClientProxyConfig.applyProxyCredentials(client, connmgr.getSchemeRegistry());
                    client.setRoutePlanner(new ProxyRoutePlanner(connmgr.getSchemeRegistry(), httpClientProxyConfig));
                }
            });
            client.setRedirectStrategy(new DefaultRedirectStrategy(){
                final String[] REDIRECT_METHODS = new String[]{"HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"};

                @Override
                protected boolean isRedirectable(String method) {
                    for (String m : this.REDIRECT_METHODS) {
                        if (!m.equalsIgnoreCase(method)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                    URI uri = this.getLocationURI(request, response, context);
                    String method = request.getRequestLine().getMethod();
                    if (method.equalsIgnoreCase("HEAD")) {
                        return new HttpHead(uri);
                    }
                    if (method.equalsIgnoreCase("GET")) {
                        return new HttpGet(uri);
                    }
                    if (method.equalsIgnoreCase("POST")) {
                        HttpPost post = new HttpPost(uri);
                        if (request instanceof HttpEntityEnclosingRequest) {
                            post.setEntity(((HttpEntityEnclosingRequest)request).getEntity());
                        }
                        return post;
                    }
                    if (method.equalsIgnoreCase("PUT")) {
                        return new HttpPut(uri);
                    }
                    if (method.equalsIgnoreCase("DELETE")) {
                        return new HttpDelete(uri);
                    }
                    if (method.equalsIgnoreCase("PATCH")) {
                        return new HttpPatch(uri);
                    }
                    return new HttpGet(uri);
                }
            });
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
        HttpParams params = client.getParams();
        HttpProtocolParams.setUserAgent(params, this.getUserAgent(options));
        HttpConnectionParams.setConnectionTimeout(params, (int)options.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(params, (int)options.getSocketTimeout());
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        HttpConnectionParams.setTcpNoDelay(params, true);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(options.getMaxCacheEntries());
        cacheConfig.setSharedCache(false);
        cacheConfig.setMaxObjectSize(options.getMaxCacheObjectSize());
        cacheConfig.setNeverCache1_0ResponsesWithQueryString(false);
        this.nonCachingHttpClient = client;
        this.httpCacheStorage = new LoggingHttpCacheStorage(new FlushableHttpCacheStorageImpl(cacheConfig));
        this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)client, this.httpCacheStorage, cacheConfig);
        this.callbackExecutor = this.httpClientOptions.getCallbackExecutor();
        this.httpClient.start();
    }

    private Option<HttpClientProxyConfig> getProxyConfig(HttpClientOptions options) {
        return ProxyConfigFactory.from(options.getProxyOptions());
    }

    private AsyncSchemeRegistry getAsyncSchemeRegistryFactory(boolean trustSelfSignedCertificates) {
        AsyncSchemeRegistry registry = new AsyncSchemeRegistry();
        registry.register(new AsyncScheme("http", 80, null));
        registry.register(new AsyncScheme("https", 443, this.getSslLayeringStrategy(trustSelfSignedCertificates)));
        return registry;
    }

    private SSLLayeringStrategy getSslLayeringStrategy(boolean trustSelfSignedCertificates) {
        try {
            return new SSLLayeringStrategy(trustSelfSignedCertificates ? new TrustSelfSignedStrategy() : null);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s / %s", httpClientVersion.get(), this.applicationName.get(), options.getUserAgent());
    }

    @Override
    public final ResponsePromise execute(Request request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return ResponsePromises.toResponsePromise((Promise<Response>)Promises.rejected((Throwable)t, Response.class));
        }
    }

    private ResponsePromise doExecute(final Request request) {
        HttpRequestBase op;
        this.httpClientOptions.getRequestPreparer().apply((Object)request);
        final long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            new RequestEntityEffect(request).apply(op);
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            op.setHeader(entry.getKey(), entry.getValue());
        }
        PromiseHttpAsyncClient asyncClient = this.getPromiseHttpAsyncClient(request);
        return ResponsePromises.toResponsePromise((Promise<Response>)asyncClient.execute(op, new BasicHttpContext()).fold((Function)new Function<Throwable, Response>(){

            public Response apply(Throwable ex) {
                long requestDuration = System.currentTimeMillis() - start;
                ApacheAsyncHttpClient.this.publishEvent(request, requestDuration, ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }, (Function)new Function<HttpResponse, Response>(){

            public Response apply(HttpResponse httpResponse) {
                long requestDuration = System.currentTimeMillis() - start;
                ApacheAsyncHttpClient.this.publishEvent(request, requestDuration, httpResponse.getStatusLine().getStatusCode());
                try {
                    return ApacheAsyncHttpClient.this.translate(httpResponse);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
    }

    private void publishEvent(Request request, long requestDuration, int statusCode) {
        if (HttpStatus.OK.code <= statusCode && statusCode < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventConsumer.apply((Object)new HttpRequestCompletedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, request.getAttributes()));
        } else {
            this.eventConsumer.apply((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, request.getAttributes()));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventConsumer.apply((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), ex.toString(), requestDuration, request.getAttributes()));
    }

    private PromiseHttpAsyncClient getPromiseHttpAsyncClient(Request request) {
        return new SettableFuturePromiseHttpPromiseAsyncClient<C>(request.isCacheDisabled() ? this.nonCachingHttpClient : this.httpClient, this.threadLocalContextManager, this.callbackExecutor);
    }

    private Response translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse.DefaultResponseBuilder responseBuilder = DefaultResponse.builder().setMaxEntitySize(this.httpClientOptions.getMaxEntitySize()).setStatusCode(status.getStatusCode()).setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            responseBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            responseBuilder.setEntityStream(entity.getContent());
        }
        return (Response)responseBuilder.build();
    }

    public void destroy() throws Exception {
        this.callbackExecutor.shutdown();
        this.httpClient.shutdown();
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpCacheStorage.flushByUriPattern(urlPattern);
    }

    private static class EventConsumerFunction
    implements Function<Object, Void> {
        private final EventPublisher eventPublisher;

        public EventConsumerFunction(EventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }

        public Void apply(Object event) {
            this.eventPublisher.publish(event);
            return null;
        }
    }

    private static final class DefaultApplicationNameSupplier
    implements Supplier<String> {
        private final ApplicationProperties applicationProperties;

        public DefaultApplicationNameSupplier(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        }

        public String get() {
            return String.format("%s-%s (%s)", this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber());
        }
    }

    private static final class NoOpThreadLocalContextManager<C>
    implements ThreadLocalContextManager<C> {
        private NoOpThreadLocalContextManager() {
        }

        public C getThreadLocalContext() {
            return null;
        }

        public void setThreadLocalContext(C context) {
        }

        public void clearThreadLocalContext() {
        }
    }
}

