/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Iterator;

public final class Pair<A, B> {
    private static final int HALF_WORD = 16;
    private final A left;
    private final B right;

    public static <A, B> Pair<A, B> pair(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    public static <A> Function<Pair<A, ?>, A> leftValue() {
        return new LeftAccessor();
    }

    public static <B> Function<Pair<?, B>, B> rightValue() {
        return new RightAccessor();
    }

    public static <A, B> Iterable<Pair<A, B>> zip(Iterable<A> as, Iterable<B> bs) {
        return new Zipper<A, B>(as, bs);
    }

    public Pair(A left, B right) {
        this.left = Preconditions.checkNotNull(left, (Object)"Left parameter must not be null.");
        this.right = Preconditions.checkNotNull(right, (Object)"Right parameter must not be null.");
    }

    public A left() {
        return this.left;
    }

    public B right() {
        return this.right;
    }

    public String toString() {
        return "Pair(" + this.left + ", " + this.right + ")";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }

    public int hashCode() {
        int lh = this.left.hashCode();
        int rh = this.right.hashCode();
        return (lh >> 16 ^ lh) << 16 | (rh << 16 ^ rh) >> 16;
    }

    static class Zipper<A, B>
    implements Iterable<Pair<A, B>> {
        private final Iterable<A> as;
        private final Iterable<B> bs;

        Zipper(Iterable<A> as, Iterable<B> bs) {
            this.as = (Iterable)Preconditions.checkNotNull(as, (Object)"as must not be null.");
            this.bs = (Iterable)Preconditions.checkNotNull(bs, (Object)"bs must not be null.");
        }

        @Override
        public Iterator<Pair<A, B>> iterator() {
            return new Iter();
        }

        class Iter
        implements Iterator<Pair<A, B>> {
            private final Iterator<A> a;
            private final Iterator<B> b;

            Iter() {
                this.a = (Iterator)Preconditions.checkNotNull(Zipper.this.as.iterator(), (Object)"as iterator must not be null.");
                this.b = (Iterator)Preconditions.checkNotNull(Zipper.this.bs.iterator(), (Object)"bs iterator must not be null.");
            }

            @Override
            public boolean hasNext() {
                return this.a.hasNext() && this.b.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                return Pair.pair(this.a.next(), this.b.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class RightAccessor<B>
    implements Function<Pair<?, B>, B> {
        RightAccessor() {
        }

        public B apply(Pair<?, B> from) {
            return from.right();
        }
    }

    static class LeftAccessor<A>
    implements Function<Pair<A, ?>, A> {
        LeftAccessor() {
        }

        public A apply(Pair<A, ?> from) {
            return from.left();
        }
    }
}

