/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;

public class Functions {
    private Functions() {
    }

    public static <F, T> T fold(Function2<T, F, T> f, T zero, Iterable<F> elements) {
        T currentValue = zero;
        for (F element : elements) {
            currentValue = f.apply(currentValue, element);
        }
        return currentValue;
    }

    public static <F, T> T fold(final Function<Pair<T, F>, T> f, T zero, Iterable<F> elements) {
        return Functions.fold(new Function2<T, F, T>(){

            @Override
            public T apply(T arg1, F arg2) {
                return f.apply(new Pair(arg1, arg2));
            }
        }, zero, elements);
    }

    static <T> Function<Supplier<? extends T>, T> fromSupplier() {
        return new ValueExtractor();
    }

    public static <A, B> Function<Function<A, B>, B> apply(final A arg) {
        return new Function<Function<A, B>, B>(){

            public B apply(Function<A, B> f) {
                return f.apply(arg);
            }
        };
    }

    public static <A, B> Function<A, Option<B>> isInstanceOf(Class<B> cls) {
        return new InstanceOf(cls);
    }

    public static <A, B> Function<A, Option<B>> partial(Predicate<? super A> p, Function<? super A, ? extends B> f) {
        return new Partial<A, B>(p, f);
    }

    public static <A, B, C> Function<A, Option<C>> compose(Function<? super B, ? extends Option<? extends C>> bc, Function<? super A, ? extends Option<? extends B>> ab) {
        return new PartialComposer(ab, bc);
    }

    public static <A, B> Function<A, Option<B>> matches(Function<? super A, ? extends Option<? extends B>> f1, Function<? super A, ? extends Option<? extends B>> f2) {
        Matcher<A, B> result = Functions.matcher(f1, f2);
        return result;
    }

    public static <A, B> Function<A, Option<B>> matches(Function<? super A, ? extends Option<? extends B>> f1, Function<? super A, ? extends Option<? extends B>> f2, Function<? super A, ? extends Option<? extends B>> f3) {
        Matcher<A, B> result = Functions.matcher(f1, f2, f3);
        return result;
    }

    public static <A, B> Function<A, Option<B>> matches(Function<? super A, ? extends Option<? extends B>> f1, Function<? super A, ? extends Option<? extends B>> f2, Function<? super A, ? extends Option<? extends B>> f3, Function<? super A, ? extends Option<? extends B>> f4) {
        Matcher result = new Matcher(ImmutableList.of(f1, f2, f3, f4));
        return result;
    }

    public static <A, B> Function<A, Option<B>> matches(Function<? super A, ? extends Option<? extends B>> f1, Function<? super A, ? extends Option<? extends B>> f2, Function<? super A, ? extends Option<? extends B>> f3, Function<? super A, ? extends Option<? extends B>> f4, Function<? super A, ? extends Option<? extends B>> f5, Function<? super A, ? extends Option<? extends B>> ... fs) {
        Matcher result = new Matcher(com.google.common.collect.Iterables.concat((Iterable)ImmutableList.of(f1, f2, f3, f4, f5), (Iterable)ImmutableList.copyOf((Object[])fs)));
        return result;
    }

    private static <A, B> Matcher<A, B> matcher(Function<? super A, ? extends Option<? extends B>> ... fs) {
        return new Matcher(ImmutableList.copyOf((Object[])fs));
    }

    public static <A, B> Function<A, Option<B>> lift(Function<? super A, ? extends B> f) {
        return new LiftedPartial<A, B>(f);
    }

    static <T> Function<Supplier<? extends T>, Supplier<T>> ignoreExceptions() {
        return new ExceptionIgnorer();
    }

    static <T> Function<T, List<T>> singletonList(Class<T> c) {
        return new SingletonList();
    }

    static Function<String, Either<NumberFormatException, Long>> parseLong() {
        return ParseLong.INSTANCE;
    }

    static <A> Function<A, Iterator<A>> singletonIterator() {
        return new Function<A, Iterator<A>>(){

            public Iterator<A> apply(A a) {
                return Iterators.singletonIterator(a);
            }
        };
    }

    static <A, X> Function<X, Iterator<A>> emptyIterator() {
        return new Function<X, Iterator<A>>(){

            public Iterator<A> apply(X a) {
                return ImmutableList.of().iterator();
            }
        };
    }

    static Function<Object, String> toStringFunction() {
        return com.google.common.base.Functions.toStringFunction();
    }

    static <A> Effect<A> toEffect(final Function<A, ?> function) {
        return new Effect<A>(){

            @Override
            public void apply(A a) {
                function.apply(a);
            }
        };
    }

    static Function<String, Either<NumberFormatException, Integer>> parseInt() {
        return ParseInt.INSTANCE;
    }

    static Function<String, Option<String>> trimToNone() {
        return TrimToNone.INSTANCE;
    }

    static <T> Function<T, T> identity() {
        return com.google.common.base.Functions.identity();
    }

    static <A> Function<A, Option<A>> option() {
        return new ToOption();
    }

    static <A, B> Function<A, B> constant(final B constant) {
        return new Function<A, B>(){

            public B apply(A from) {
                return constant;
            }
        };
    }

    private static class ToOption<A>
    implements Function<A, Option<A>> {
        private ToOption() {
        }

        public Option<A> apply(A from) {
            return Option.option(from);
        }
    }

    private static enum TrimToNone implements Function<String, Option<String>>
    {
        INSTANCE;


        public Option<String> apply(String s) {
            if (s == null) {
                return Option.none();
            }
            String trimmed = s.trim();
            return trimmed.isEmpty() ? Option.none() : Option.some(trimmed);
        }
    }

    private static enum ParseInt implements Function<String, Either<NumberFormatException, Integer>>
    {
        INSTANCE;


        public Either<NumberFormatException, Integer> apply(String s) {
            try {
                return Either.right(Integer.valueOf(s));
            }
            catch (NumberFormatException e) {
                return Either.left(e);
            }
        }
    }

    private static enum ParseLong implements Function<String, Either<NumberFormatException, Long>>
    {
        INSTANCE;


        public Either<NumberFormatException, Long> apply(String s) {
            try {
                return Either.right(Long.valueOf(s));
            }
            catch (NumberFormatException e) {
                return Either.left(e);
            }
        }
    }

    private static final class SingletonList<T>
    implements Function<T, List<T>> {
        private SingletonList() {
        }

        public List<T> apply(T o) {
            return ImmutableList.of(o);
        }
    }

    static class IgnoreAndReturnNull<T>
    implements Supplier<T> {
        private final Supplier<? extends T> delegate;

        IgnoreAndReturnNull(Supplier<? extends T> delegate) {
            this.delegate = (Supplier)Preconditions.checkNotNull(delegate);
        }

        public T get() {
            try {
                return (T)this.delegate.get();
            }
            catch (RuntimeException ignore) {
                return null;
            }
        }
    }

    static class ExceptionIgnorer<T>
    implements Function<Supplier<? extends T>, Supplier<T>> {
        ExceptionIgnorer() {
        }

        public Supplier<T> apply(Supplier<? extends T> from) {
            return new IgnoreAndReturnNull<T>(from);
        }
    }

    static class LiftedPartial<A, B>
    implements Function<A, Option<B>> {
        private final Function<? super A, ? extends B> f;

        LiftedPartial(Function<? super A, ? extends B> f) {
            this.f = f;
        }

        public Option<B> apply(A a) {
            return Option.option(this.f.apply(a));
        }
    }

    static class Matcher<A, B>
    implements Function<A, Option<B>> {
        private final Iterable<Function<? super A, ? extends Option<? extends B>>> fs;

        Matcher(Iterable<Function<? super A, ? extends Option<? extends B>>> fs) {
            this.fs = (Iterable)Preconditions.checkNotNull(fs);
            Preconditions.checkState((!Iterables.isEmpty().apply(this.fs) ? 1 : 0) != 0);
        }

        public Option<B> apply(A a) {
            for (Function<? super A, ? extends Option<? extends B>> function : this.fs) {
                Option b = (Option)function.apply(a);
                if (!b.isDefined()) continue;
                return b;
            }
            return Option.none();
        }
    }

    static class PartialComposer<A, B, C>
    implements Function<A, Option<C>> {
        private final Function<? super A, ? extends Option<? extends B>> ab;
        private final Function<? super B, ? extends Option<? extends C>> bc;

        PartialComposer(Function<? super A, ? extends Option<? extends B>> ab, Function<? super B, ? extends Option<? extends C>> bc) {
            this.ab = (Function)Preconditions.checkNotNull(ab);
            this.bc = (Function)Preconditions.checkNotNull(bc);
        }

        public Option<C> apply(A a) {
            return ((Option)this.ab.apply(a)).flatMap(this.bc);
        }
    }

    static class Partial<A, B>
    implements Function<A, Option<B>> {
        private final Predicate<? super A> p;
        private final Function<? super A, ? extends B> f;

        Partial(Predicate<? super A> p, Function<? super A, ? extends B> f) {
            this.p = (Predicate)Preconditions.checkNotNull(p);
            this.f = (Function)Preconditions.checkNotNull(f);
        }

        public Option<B> apply(A a) {
            return this.p.apply(a) ? Option.option(this.f.apply(a)) : Option.none();
        }
    }

    static class InstanceOf<A, B>
    implements Function<A, Option<B>> {
        private final Class<B> cls;

        InstanceOf(Class<B> cls) {
            this.cls = (Class)Preconditions.checkNotNull(cls);
        }

        public Option<B> apply(A a) {
            return this.cls.isAssignableFrom(a.getClass()) ? Option.some(this.cls.cast(a)) : Option.none();
        }
    }

    private static class ValueExtractor<T>
    implements Function<Supplier<? extends T>, T> {
        private ValueExtractor() {
        }

        public T apply(Supplier<? extends T> supplier) {
            return (T)supplier.get();
        }
    }
}

