/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue.retry;

import com.atlassian.fugue.retry.BeforeRetryExponentialBackoffTask;
import com.atlassian.fugue.retry.ExceptionHandler;
import com.atlassian.fugue.retry.ExceptionHandlers;
import com.atlassian.fugue.retry.RetryFunction;
import com.atlassian.fugue.retry.RetrySupplier;
import com.atlassian.fugue.retry.RetryTask;
import com.google.common.base.Function;
import com.google.common.base.Supplier;

public class RetryFactory {
    private RetryFactory() {
        throw new AssertionError((Object)"This class is non-instantiable.");
    }

    public static Runnable create(Runnable task, int tries) {
        return RetryFactory.create(task, tries, ExceptionHandlers.ignoreExceptionHandler());
    }

    public static Runnable create(Runnable task, int tries, ExceptionHandler handler) {
        return new RetryTask(task, tries, handler);
    }

    public static Runnable create(Runnable task, int tries, ExceptionHandler handler, long backoff) {
        return new RetryTask(task, tries, handler, new BeforeRetryExponentialBackoffTask(backoff));
    }

    public static <T> Supplier<T> create(Supplier<T> supplier, int tries) {
        return RetryFactory.create(supplier, tries, ExceptionHandlers.ignoreExceptionHandler());
    }

    public static <T> Supplier<T> create(Supplier<T> supplier, int tries, ExceptionHandler handler) {
        return new RetrySupplier<T>(supplier, tries, handler);
    }

    public static <T> Supplier<T> create(Supplier<T> supplier, int tries, ExceptionHandler handler, long backoff) {
        return new RetrySupplier<T>(supplier, tries, handler, new BeforeRetryExponentialBackoffTask(backoff));
    }

    public static <F, T> Function<F, T> create(Function<F, T> function, int tries) {
        return RetryFactory.create(function, tries, ExceptionHandlers.ignoreExceptionHandler());
    }

    public static <F, T> Function<F, T> create(Function<F, T> function, int tries, ExceptionHandler handler) {
        return RetryFactory.create(function, tries, handler, 0L);
    }

    public static <F, T> Function<F, T> create(Function<F, T> function, int tries, ExceptionHandler handler, long backoff) {
        return new RetryFunction<F, T>(function, tries, handler, new BeforeRetryExponentialBackoffTask(backoff));
    }
}

