/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.CommonBuilder;
import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.apache.httpcomponents.Headers;
import com.atlassian.httpclient.api.Response;
import java.io.InputStream;
import java.util.Map;

public final class DefaultResponse
extends DefaultMessage
implements Response {
    private int statusCode;
    private String statusText;

    public DefaultResponse(Headers headers, InputStream entityStream, Option<Long> maxEntitySize, int statusCode, String statusText) {
        super(headers, entityStream, maxEntitySize);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public static DefaultResponseBuilder builder() {
        return new DefaultResponseBuilder();
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    @Override
    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public boolean isOk() {
        return this.statusCode == 200;
    }

    @Override
    public boolean isCreated() {
        return this.statusCode == 201;
    }

    @Override
    public boolean isNoContent() {
        return this.statusCode == 204;
    }

    @Override
    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    @Override
    public boolean isSeeOther() {
        return this.statusCode == 303;
    }

    @Override
    public boolean isNotModified() {
        return this.statusCode == 304;
    }

    @Override
    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    @Override
    public boolean isBadRequest() {
        return this.statusCode == 400;
    }

    @Override
    public boolean isUnauthorized() {
        return this.statusCode == 401;
    }

    @Override
    public boolean isForbidden() {
        return this.statusCode == 403;
    }

    @Override
    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    @Override
    public boolean isConflict() {
        return this.statusCode == 409;
    }

    @Override
    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    @Override
    public boolean isInternalServerError() {
        return this.statusCode == 500;
    }

    @Override
    public boolean isServiceUnavailable() {
        return this.statusCode == 503;
    }

    @Override
    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    @Override
    public boolean isNotSuccessful() {
        return this.isInformational() || this.isRedirection() || this.isError();
    }

    public static class DefaultResponseBuilder
    implements Response.Builder<DefaultResponse> {
        private final CommonBuilder<DefaultResponse> commonBuilder = new CommonBuilder();
        private String statusText;
        private int statusCode;
        private long maxEntitySize;

        private DefaultResponseBuilder() {
        }

        @Override
        public Response.Builder<DefaultResponse> setContentType(String contentType) {
            this.commonBuilder.setContentType(contentType);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setContentCharset(String contentCharset) {
            this.commonBuilder.setContentCharset(contentCharset);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setHeaders(Map<String, String> headers) {
            this.commonBuilder.setHeaders((Map)headers);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setHeader(String name, String value) {
            this.commonBuilder.setHeader(name, value);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setEntity(String entity) {
            this.commonBuilder.setEntity(entity);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setEntityStream(InputStream entityStream, String encoding) {
            this.commonBuilder.setEntityStream(entityStream);
            this.commonBuilder.setContentCharset(encoding);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setEntityStream(InputStream entityStream) {
            this.commonBuilder.setEntityStream(entityStream);
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setStatusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        @Override
        public Response.Builder<DefaultResponse> setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Response.Builder<DefaultResponse> setMaxEntitySize(long maxEntitySize) {
            this.maxEntitySize = maxEntitySize;
            return this;
        }

        @Override
        public DefaultResponse build() {
            return new DefaultResponse(this.commonBuilder.getHeaders(), this.commonBuilder.getEntityStream(), Option.option(this.maxEntitySize), this.statusCode, this.statusText);
        }
    }
}

