/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api.factory;

import com.atlassian.httpclient.api.Request;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Effects;
import com.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class HttpClientOptions {
    private String threadPrefix = "httpclient";
    private int ioThreadCount = 10;
    private long ioSelectInterval = 1000L;
    private long connectionTimeout = 5000L;
    private long socketTimeout = 20000L;
    private long requestTimeout = 90000L;
    private int maxConnectionsPerHost = 20;
    private long connectionPoolTimeToLive = 30000L;
    private long maxCacheObjectSize = 102400L;
    private int maxCacheEntries = 100;
    private long maxEntitySize = 0x6400000L;
    private long leaseTimeout = 600000L;
    private Effect<Request> requestPreparer = Effects.noop();
    private String userAgent = "Default";
    private ExecutorService callbackExecutor;

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    public long getIoSelectInterval() {
        return this.ioSelectInterval;
    }

    public void setIoSelectInterval(int ioSelectInterval, TimeUnit timeUnit) {
        this.ioSelectInterval = timeUnit.toMillis(ioSelectInterval);
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout, TimeUnit timeUnit) {
        this.connectionTimeout = timeUnit.toMillis(connectionTimeout);
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = timeUnit.toMillis(socketTimeout);
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout, TimeUnit timeUnit) {
        this.requestTimeout = timeUnit.toMillis(requestTimeout);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getThreadPrefix() {
        return this.threadPrefix;
    }

    public void setThreadPrefix(String threadPrefix) {
        this.threadPrefix = threadPrefix;
    }

    public long getConnectionPoolTimeToLive() {
        return this.connectionPoolTimeToLive;
    }

    public void setConnectionPoolTimeToLive(int connectionPoolTimeToLive, TimeUnit timeUnit) {
        this.connectionPoolTimeToLive = timeUnit.toMillis(connectionPoolTimeToLive);
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public long getMaxCacheObjectSize() {
        return this.maxCacheObjectSize;
    }

    public void setMaxCacheObjectSize(long maxCacheObjectSize) {
        this.maxCacheObjectSize = maxCacheObjectSize;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public Effect<Request> getRequestPreparer() {
        return this.requestPreparer;
    }

    public void setRequestPreparer(Effect<Request> requestPreparer) {
        this.requestPreparer = requestPreparer;
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public long getLeaseTimeout() {
        return this.leaseTimeout;
    }

    public void setLeaseTimeout(long leaseTimeout) {
        this.leaseTimeout = leaseTimeout;
    }

    public void setMaxEntitySize(long maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    public ExecutorService getCallbackExecutor() {
        return this.callbackExecutor != null ? this.callbackExecutor : this.defaultCallbackExecutor();
    }

    private ExecutorService defaultCallbackExecutor() {
        return Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory(this.getThreadPrefix() + "-callbacks", ThreadFactories.Type.DAEMON));
    }
}

