/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    private static final String UNKNOWN_VERSION = "unknown";

    MavenUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getVersion(String groupId, String artifactId) {
        String string;
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = (InputStream)MavenUtils.getPomInputStreamSupplier(groupId, artifactId).getInput();
            props.load(is);
            string = props.getProperty("version", UNKNOWN_VERSION);
        }
        catch (Exception e) {
            String string2;
            try {
                logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
                logger.debug("Got the following exception:", (Throwable)e);
                string2 = UNKNOWN_VERSION;
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)is);
            return string2;
        }
        Closeables.closeQuietly((Closeable)is);
        return string;
    }

    private static InputSupplier<InputStream> getPomInputStreamSupplier(String groupId, String artifactId) {
        return Resources.newInputStreamSupplier((URL)Resources.getResource(MavenUtils.class, (String)MavenUtils.getPomFilePath(groupId, artifactId)));
    }

    private static String getPomFilePath(String groupId, String artifactId) {
        return String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
    }
}

