/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.EntityByteArrayInputStream;
import com.atlassian.httpclient.api.Entity;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;

public class HttpEntityFactory {
    static HttpEntity getHttpEntity(Entity entity) {
        InputStream entityStream = (InputStream)Preconditions.checkNotNull((Object)entity.inputStream());
        if (entityStream instanceof ByteArrayInputStream) {
            byte[] bytes;
            if (entityStream instanceof EntityByteArrayInputStream) {
                bytes = ((EntityByteArrayInputStream)entityStream).getBytes();
            } else {
                try {
                    bytes = ByteStreams.toByteArray((InputStream)entityStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new ByteArrayEntity(bytes);
        }
        return new InputStreamEntity(entityStream, -1L);
    }
}

