/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHeaders;
import com.atlassian.httpclient.api.Headers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.util.Map;

class HeadersBuilder
implements Headers.Builder {
    private Charset contentCharset;
    private ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();

    public static Headers.Builder builder() {
        return new HeadersBuilder();
    }

    private HeadersBuilder() {
    }

    @Override
    public Headers build() {
        return new DefaultHeaders((Map<String, String>)this.headers.build(), Option.option(this.contentCharset));
    }

    @Override
    public Headers.Builder add(String name, String value) {
        this.headers.put((Object)name, (Object)value);
        return this;
    }

    @Override
    public Headers.Builder addAll(Iterable<Pair<String, String>> hs) {
        for (Pair<String, String> p : hs) {
            this.add(p.left(), p.right());
        }
        return this;
    }

    @Override
    public Headers.Builder addAll(Map<String, String> headers) {
        headers.putAll(headers);
        return this;
    }

    @Override
    public Headers.Builder setContentType(String contentType) {
        this.add("Content-Type", contentType);
        this.parseCharset(contentType).foreach(new Effect<String>(){

            @Override
            public void apply(String contentCharset) {
                HeadersBuilder.this.setContentCharset(contentCharset);
            }
        });
        return this;
    }

    @Override
    public Headers.Builder setAccept(String accept) {
        this.add("Accept", accept);
        return this;
    }

    private Option<String> parseCharset(String contentType) {
        String subtype;
        String[] parts;
        if (contentType != null && (parts = contentType.split(";")).length >= 2 && (subtype = parts[1].trim()).startsWith("charset=")) {
            return Option.some(subtype.substring(8));
        }
        return Option.none();
    }

    @Override
    public Headers.Builder setContentCharset(String contentCharset) {
        Preconditions.checkNotNull((Object)contentCharset);
        this.contentCharset = Charset.forName(contentCharset);
        return this;
    }
}

