/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.Headers;
import com.atlassian.httpclient.api.Response;

public final class DefaultResponse
extends DefaultMessage
implements Response {
    private final int statusCode;
    private final String statusText;

    DefaultResponse(Option<Entity> entity, Headers headers, int statusCode, String statusText) {
        super(headers, entity);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusText() {
        return this.statusText;
    }

    @Override
    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    @Override
    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public boolean isOk() {
        return this.statusCode == 200;
    }

    @Override
    public boolean isCreated() {
        return this.statusCode == 201;
    }

    @Override
    public boolean isNoContent() {
        return this.statusCode == 204;
    }

    @Override
    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    @Override
    public boolean isSeeOther() {
        return this.statusCode == 303;
    }

    @Override
    public boolean isNotModified() {
        return this.statusCode == 304;
    }

    @Override
    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    @Override
    public boolean isBadRequest() {
        return this.statusCode == 400;
    }

    @Override
    public boolean isUnauthorized() {
        return this.statusCode == 401;
    }

    @Override
    public boolean isForbidden() {
        return this.statusCode == 403;
    }

    @Override
    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    @Override
    public boolean isConflict() {
        return this.statusCode == 409;
    }

    @Override
    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    @Override
    public boolean isInternalServerError() {
        return this.statusCode == 500;
    }

    @Override
    public boolean isServiceUnavailable() {
        return this.statusCode == 503;
    }

    @Override
    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    @Override
    public boolean isNotSuccessful() {
        return this.isInformational() || this.isRedirection() || this.isError();
    }
}

