/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.httpclient.apache.httpcomponents.AsyncHttpClient;
import com.atlassian.httpclient.apache.httpcomponents.DefaultAsyncHttpClient;
import com.atlassian.httpclient.apache.httpcomponents.DefaultEntity;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHeaders;
import com.atlassian.httpclient.apache.httpcomponents.EntityByteArrayInputStream;
import com.atlassian.httpclient.apache.httpcomponents.HeadersBuilder;
import com.atlassian.httpclient.apache.httpcomponents.HttpClientBuilders;
import com.atlassian.httpclient.apache.httpcomponents.HttpEntityFactory;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.ProxySelectorAsyncRoutePlanner;
import com.atlassian.httpclient.apache.httpcomponents.RequestBuilder;
import com.atlassian.httpclient.apache.httpcomponents.RequestNotOk;
import com.atlassian.httpclient.apache.httpcomponents.ResponseBuilder;
import com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorage;
import com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorageImpl;
import com.atlassian.httpclient.apache.httpcomponents.cache.LoggingHttpCacheStorage;
import com.atlassian.httpclient.api.Builders;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.Headers;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClient<C>
implements HttpClient,
DisposableBean {
    private static final Supplier<String> httpClientVersion = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            return MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api");
        }
    });
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Builders httpClientBuilders = new HttpClientBuilders();
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final HttpAsyncClient httpClient;
    private final HttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventPublisher, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        DefaultHttpAsyncClient client;
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull(threadLocalContextManager);
        this.httpClientOptions = (HttpClientOptions)Preconditions.checkNotNull((Object)options);
        try {
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(options.getIoThreadCount());
            ioReactorConfig.setSelectInterval(options.getIoSelectInterval());
            ioReactorConfig.setInterestOpQueued(true);
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                @Override
                public boolean handle(IOException ex) {
                    DefaultHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                @Override
                public boolean handle(RuntimeException ex) {
                    DefaultHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            PoolingClientAsyncConnectionManager connmgr = new PoolingClientAsyncConnectionManager(reactor, AsyncSchemeRegistryFactory.createDefault(), options.getConnectionPoolTimeToLive(), options.getLeaseTimeout(), TimeUnit.MILLISECONDS){

                @Override
                protected void finalize() throws Throwable {
                }
            };
            connmgr.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            client = new DefaultHttpAsyncClient(connmgr);
            client.setRedirectStrategy(new DefaultRedirectStrategy(){
                final String[] REDIRECT_METHODS = new String[]{"HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"};

                @Override
                protected boolean isRedirectable(String method) {
                    for (String m : this.REDIRECT_METHODS) {
                        if (!m.equalsIgnoreCase(method)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                    URI uri = this.getLocationURI(request, response, context);
                    String method = request.getRequestLine().getMethod();
                    if (method.equalsIgnoreCase("HEAD")) {
                        return new HttpHead(uri);
                    }
                    if (method.equalsIgnoreCase("GET")) {
                        return new HttpGet(uri);
                    }
                    if (method.equalsIgnoreCase("POST")) {
                        HttpPost post = new HttpPost(uri);
                        if (request instanceof HttpEntityEnclosingRequest) {
                            post.setEntity(((HttpEntityEnclosingRequest)request).getEntity());
                        }
                        return post;
                    }
                    if (method.equalsIgnoreCase("PUT")) {
                        return new HttpPut(uri);
                    }
                    if (method.equalsIgnoreCase("DELETE")) {
                        return new HttpDelete(uri);
                    }
                    if (method.equalsIgnoreCase("PATCH")) {
                        return new HttpPatch(uri);
                    }
                    return new HttpGet(uri);
                }
            });
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
        HttpParams params = client.getParams();
        HttpProtocolParams.setUserAgent(params, this.getUserAgent(options));
        HttpConnectionParams.setConnectionTimeout(params, (int)options.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(params, (int)options.getSocketTimeout());
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        HttpConnectionParams.setTcpNoDelay(params, true);
        ProxySelectorAsyncRoutePlanner routePlanner = new ProxySelectorAsyncRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner(routePlanner);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(options.getMaxCacheEntries());
        cacheConfig.setSharedCache(false);
        cacheConfig.setMaxObjectSize(options.getMaxCacheObjectSize());
        cacheConfig.setNeverCache1_0ResponsesWithQueryString(false);
        this.nonCachingHttpClient = client;
        this.httpCacheStorage = new LoggingHttpCacheStorage(new FlushableHttpCacheStorageImpl(cacheConfig));
        this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)client, this.httpCacheStorage, cacheConfig);
        this.callbackExecutor = this.httpClientOptions.getCallbackExecutor();
        this.httpClient.start();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s-%s (%s) / %s", httpClientVersion.get(), this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber(), options.getUserAgent());
    }

    @Override
    public final Promise<Response> execute(Request request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return Promises.rejected((Throwable)t, Response.class);
        }
    }

    @Override
    public Builders builders() {
        return this.httpClientBuilders;
    }

    private Promise<Response> doExecute(final Request request) {
        this.httpClientOptions.getRequestPreparer().apply((Object)request);
        final long start = System.currentTimeMillis();
        HttpRequestBase op = this.getMethod(request);
        request.entity().foreach(this.setEntity(op));
        for (Pair entry : request.headers()) {
            op.setHeader((String)entry.left(), (String)entry.right());
        }
        return this.async().execute(op, new BasicHttpContext()).fold((Function)new Function<Throwable, Response>(){

            public Response apply(Throwable ex) {
                long requestDuration = System.currentTimeMillis() - start;
                DefaultHttpClient.this.publishEvent(request, requestDuration, ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }, (Function)new Function<HttpResponse, Response>(){

            public Response apply(HttpResponse httpResponse) {
                long requestDuration = System.currentTimeMillis() - start;
                DefaultHttpClient.this.publishEvent(request, requestDuration, HttpStatus.fromCode(httpResponse.getStatusLine().getStatusCode()));
                try {
                    return DefaultHttpClient.this.translate(httpResponse);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    private void publishEvent(Request request, long duration, HttpStatus status) {
        if (HttpStatus.OK.code <= status.code && status.code < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventPublisher.publish((Object)new HttpRequestCompletedEvent(request, duration));
        } else {
            this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request, new RequestNotOk(status)));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request, ex));
    }

    private AsyncHttpClient async() {
        return new DefaultAsyncHttpClient<C>(this.httpClient, this.threadLocalContextManager, this.callbackExecutor);
    }

    private Response translate(HttpResponse httpResponse) throws IOException {
        StatusLine status = httpResponse.getStatusLine();
        Response.Builder response = ResponseBuilder.builder();
        response.setStatusCode(status.getStatusCode());
        response.setStatusText(status.getReasonPhrase());
        response.setHeaders(DefaultHeaders.from(httpResponse.getAllHeaders()));
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response.setEntity(new DefaultEntity(new DefaultHeaders((Map<String, String>)ImmutableMap.of(), Option.<Charset>none()), this.httpClientOptions.getMaxEntitySize(), entity.getContent()));
        }
        return (Response)response.build();
    }

    public void destroy() throws Exception {
        this.callbackExecutor.shutdown();
        this.httpClient.shutdown();
    }

    private HttpRequestBase getMethod(Request request) {
        String uri = request.uri().toString();
        switch (request.method()) {
            case GET: {
                return new HttpGet(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
        }
        throw new UnsupportedOperationException(request.method().toString());
    }

    private Effect<Entity> setEntity(final HttpRequestBase op) {
        return new Effect<Entity>(){

            @Override
            public void apply(Entity entity) {
                if (!(op instanceof HttpEntityEnclosingRequestBase)) {
                    throw new UnsupportedOperationException("HTTP method " + op.getMethod() + " does not support sending an entity");
                }
                ((HttpEntityEnclosingRequestBase)op).setEntity(HttpEntityFactory.getHttpEntity(entity));
            }
        };
    }

    @Override
    public Request.Builder newRequest() {
        return RequestBuilder.builder();
    }

    @Override
    public Request.Builder newRequest(URI uri) {
        return RequestBuilder.builder().uri(uri);
    }

    @Override
    public Request.Builder newRequest(String uri) {
        return RequestBuilder.builder().url(uri);
    }

    @Override
    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        Headers.Builder headersBuilder = HeadersBuilder.builder().setContentType(contentType);
        return (Request.Builder)((Request.Builder)RequestBuilder.builder().uri(uri).setEntity(new StringEntity(contentType, entity))).setHeaders((Headers)headersBuilder.build());
    }

    @Override
    public Request.Builder newRequest(String url, String contentType, String entity) {
        Headers.Builder headersBuilder = HeadersBuilder.builder().setContentType(contentType);
        return (Request.Builder)((Request.Builder)RequestBuilder.builder().url(url).setEntity(new StringEntity(contentType, entity))).setHeaders((Headers)headersBuilder.build());
    }

    private static class StringEntity
    implements Entity {
        private final String contentType;
        private final String entity;

        private StringEntity(String contentType, String entity) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            this.entity = (String)Preconditions.checkNotNull((Object)entity);
        }

        @Override
        public Headers headers() {
            return new DefaultHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)this.contentType), Option.some(Charsets.UTF_8));
        }

        @Override
        public InputStream inputStream() {
            return new EntityByteArrayInputStream(this.entity.getBytes(Charsets.UTF_8));
        }
    }
}

