/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHeaders;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.FormBuilder;
import com.atlassian.httpclient.api.Headers;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class DefaultFormBuilder
implements FormBuilder {
    private Map<String, List<String>> parameters = Maps.newLinkedHashMap();

    @Override
    public FormBuilder addParam(String name) {
        return this.addParam(name, null);
    }

    @Override
    public FormBuilder addParam(String name, String value) {
        LinkedList values = this.parameters.get(name);
        if (values == null) {
            values = Lists.newLinkedList();
            this.parameters.put(name, values);
        }
        values.add(value);
        return this;
    }

    @Override
    public FormBuilder setParam(String name, Iterable<String> values) {
        this.parameters.put(name, Lists.newLinkedList(values));
        return this;
    }

    @Override
    public Entity build() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            String name = this.encode(entry.getKey());
            List<String> values = entry.getValue();
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(name);
                if (value == null) continue;
                buf.append("=");
                buf.append(this.encode(value));
            }
        }
        final byte[] bytes = buf.toString().getBytes(Charset.forName("UTF-8"));
        return new Entity(){

            @Override
            public Headers headers() {
                return new DefaultHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/x-www-form-urlencoded"), Option.some(Charsets.UTF_8));
            }

            @Override
            public InputStream inputStream() {
                return new ByteArrayInputStream(bytes);
            }
        };
    }

    private String encode(String str) {
        try {
            str = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return str;
    }
}

