/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.DefaultResponseTransformationPromise;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformationPromise;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class WrappingResponsePromise
implements ResponsePromise {
    private final Promise<Response> delegate;

    public WrappingResponsePromise(ListenableFuture<Response> delegate) {
        this.delegate = Promises.forListenableFuture(delegate);
    }

    @Override
    public <T> ResponseTransformationPromise<T> transform() {
        return new DefaultResponseTransformationPromise(this);
    }

    public Response claim() {
        return (Response)this.delegate.claim();
    }

    public Promise<Response> done(Effect<Response> e) {
        return this.delegate.done(e);
    }

    public Promise<Response> fail(Effect<Throwable> e) {
        return this.delegate.fail(e);
    }

    public Promise<Response> then(FutureCallback<Response> callback) {
        return this.delegate.then(callback);
    }

    public <B> Promise<B> map(Function<? super Response, ? extends B> function) {
        return this.delegate.map(function);
    }

    public <B> Promise<B> flatMap(Function<? super Response, Promise<B>> function) {
        return this.delegate.flatMap(function);
    }

    public Promise<Response> recover(Function<Throwable, ? extends Response> handleThrowable) {
        return this.delegate.recover(handleThrowable);
    }

    public <B> Promise<B> fold(Function<Throwable, ? extends B> handleThrowable, Function<? super Response, ? extends B> function) {
        return this.delegate.fold(handleThrowable, function);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public Response get() throws InterruptedException, ExecutionException {
        return (Response)this.delegate.get();
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Response)this.delegate.get(timeout, unit);
    }
}

