/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromiseMapFunction;
import com.atlassian.httpclient.api.ResponseTransformationException;
import com.atlassian.httpclient.api.ResponseTransformationPromise;
import com.atlassian.httpclient.api.UnexpectedResponseException;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class DefaultResponseTransformationPromise<O>
implements ResponseTransformationPromise<O> {
    private volatile Promise<O> delegate;
    private final ResponsePromise responsePromise;
    private SingleMatchDelegatingFunction<Throwable, Function<Throwable, ? extends O>> failFunction;
    private SingleMatchDelegatingFunction<Response, ResponsePromiseMapFunction<O>> doneFunction;

    DefaultResponseTransformationPromise(ResponsePromise baseResponsePromise) {
        Preconditions.checkNotNull((Object)baseResponsePromise);
        this.responsePromise = baseResponsePromise;
        this.failFunction = new SingleMatchDelegatingFunction(this, this.defaultThrowableHandler());
        this.doneFunction = new SingleMatchDelegatingFunction(this, new ResponsePromiseMapFunction());
    }

    @Override
    public ResponseTransformationPromise<O> on(int statusCode, Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.fromCode(statusCode), f);
    }

    @Override
    public ResponseTransformationPromise<O> informational(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.CONTINUE, f);
    }

    @Override
    public ResponseTransformationPromise<O> successful(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformationPromise<O> ok(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformationPromise<O> created(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CREATED, f);
    }

    @Override
    public ResponseTransformationPromise<O> noContent(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NO_CONTENT, f);
    }

    @Override
    public ResponseTransformationPromise<O> redirection(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.MULTIPLE_CHOICES, f);
    }

    @Override
    public ResponseTransformationPromise<O> seeOther(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SEE_OTHER, f);
    }

    @Override
    public ResponseTransformationPromise<O> notModified(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_MODIFIED, f);
    }

    @Override
    public ResponseTransformationPromise<O> clientError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformationPromise<O> badRequest(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformationPromise<O> unauthorized(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.UNAUTHORIZED, f);
    }

    @Override
    public ResponseTransformationPromise<O> forbidden(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.FORBIDDEN, f);
    }

    @Override
    public ResponseTransformationPromise<O> notFound(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_FOUND, f);
    }

    @Override
    public ResponseTransformationPromise<O> conflict(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CONFLICT, f);
    }

    @Override
    public ResponseTransformationPromise<O> serverError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformationPromise<O> internalServerError(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformationPromise<O> serviceUnavailable(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SERVICE_UNAVAILABLE, f);
    }

    @Override
    public ResponseTransformationPromise<O> error(Function<Response, ? extends O> f) {
        ((ResponsePromiseMapFunction)((SingleMatchDelegatingFunction)this.doneFunction).delegate).addStatusRangeFunction(new OrStatusRange(new HundredsStatusRange(HttpStatus.BAD_REQUEST), new HundredsStatusRange(HttpStatus.INTERNAL_SERVER_ERROR)), f);
        this.applyFold();
        return this;
    }

    private void applyFold() {
        if (!this.doneFunction.isMatched() && !this.failFunction.isMatched()) {
            this.delegate = this.responsePromise.fold(this.failFunction, this.doneFunction);
        }
    }

    @Override
    public ResponseTransformationPromise<O> notSuccessful(Function<Response, ? extends O> f) {
        ((ResponsePromiseMapFunction)((SingleMatchDelegatingFunction)this.doneFunction).delegate).addStatusRangeFunction(new NotInStatusRange(new HundredsStatusRange(HttpStatus.OK)), f);
        this.applyFold();
        return this;
    }

    @Override
    public ResponseTransformationPromise<O> others(Function<Response, ? extends O> f) {
        ((ResponsePromiseMapFunction)((SingleMatchDelegatingFunction)this.doneFunction).delegate).setOthersFunction(f);
        this.applyFold();
        return this;
    }

    @Override
    public ResponseTransformationPromise<O> otherwise(final Function<Throwable, O> callback) {
        this.others(new Function<Response, O>(){

            public O apply(@Nullable Response input) {
                return callback.apply((Object)new UnexpectedResponseException(input));
            }
        });
        this.fail(callback);
        return this;
    }

    @Override
    public ResponseTransformationPromise<O> done(final Function<Response, O> f) {
        this.others(new Function<Response, O>(){

            public O apply(@Nullable Response input) {
                return f.apply((Object)input);
            }
        });
        return this;
    }

    @Override
    public ResponseTransformationPromise<O> fail(Function<Throwable, ? extends O> f) {
        this.failFunction.setDelegate(f);
        this.applyFold();
        return this;
    }

    private ResponseTransformationPromise<O> addSingle(HttpStatus status, Function<Response, ? extends O> f) {
        ((ResponsePromiseMapFunction)((SingleMatchDelegatingFunction)this.doneFunction).delegate).addStatusRangeFunction(new SingleStatusRange(status), f);
        this.applyFold();
        return this;
    }

    private ResponseTransformationPromise<O> addRange(HttpStatus status, Function<Response, ? extends O> f) {
        ((ResponsePromiseMapFunction)((SingleMatchDelegatingFunction)this.doneFunction).delegate).addStatusRangeFunction(new HundredsStatusRange(status), f);
        this.applyFold();
        return this;
    }

    public O claim() {
        return (O)this.delegate.claim();
    }

    public Promise<O> done(Effect<O> oEffect) {
        return this.delegate.done(oEffect);
    }

    public Promise<O> fail(Effect<Throwable> throwableEffect) {
        return this.delegate.fail(throwableEffect);
    }

    public Promise<O> then(FutureCallback<O> oFutureCallback) {
        return this.delegate.then(oFutureCallback);
    }

    public <B> Promise<B> map(Function<? super O, ? extends B> function) {
        return this.delegate.map(function);
    }

    public <B> Promise<B> flatMap(Function<? super O, Promise<B>> promiseFunction) {
        return this.delegate.flatMap(promiseFunction);
    }

    public Promise<O> recover(Function<Throwable, ? extends O> throwableFunction) {
        return this.delegate.recover(throwableFunction);
    }

    public <B> Promise<B> fold(Function<Throwable, ? extends B> throwableFunction, Function<? super O, ? extends B> function) {
        return this.delegate.fold(throwableFunction, function);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public O get() throws InterruptedException, ExecutionException {
        return (O)this.delegate.get();
    }

    public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (O)this.delegate.get(timeout, unit);
    }

    private Function<Throwable, ? extends O> defaultThrowableHandler() {
        return new Function<Throwable, O>(){

            public O apply(Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new ResponseTransformationException(throwable);
            }
        };
    }

    static final class OrStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange one;
        private final ResponsePromiseMapFunction.StatusRange two;

        private OrStatusRange(ResponsePromiseMapFunction.StatusRange one, ResponsePromiseMapFunction.StatusRange two) {
            this.one = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)one);
            this.two = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)two);
        }

        @Override
        public boolean isIn(int code) {
            return this.one.isIn(code) || this.two.isIn(code);
        }
    }

    static final class NotInStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange range;

        private NotInStatusRange(ResponsePromiseMapFunction.StatusRange range) {
            this.range = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)range);
        }

        @Override
        public boolean isIn(int code) {
            return !this.range.isIn(code);
        }
    }

    static final class HundredsStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        private HundredsStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            int diff = code - this.status.code;
            return 0 <= diff && diff < 100;
        }
    }

    static final class SingleStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        SingleStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            return this.status.code == code;
        }
    }

    static final class SingleMatchDelegatingFunction<INPUT, DELEGATE extends Function<INPUT, ? extends O>>
    implements Function<INPUT, O> {
        private DELEGATE delegate;
        private volatile O matchValue;
        private volatile RuntimeException thrownExceptionMatch;
        private volatile Error thrownErrorMatch;
        private volatile boolean match;
        final /* synthetic */ DefaultResponseTransformationPromise this$0;

        public SingleMatchDelegatingFunction(DELEGATE delegateDefault) {
            this.this$0 = var1_1;
            this.delegate = delegateDefault;
        }

        public O apply(@Nullable INPUT input) {
            if (this.thrownErrorMatch != null) {
                throw this.thrownErrorMatch;
            }
            if (this.thrownExceptionMatch != null) {
                throw this.thrownExceptionMatch;
            }
            if (this.match) {
                return this.matchValue;
            }
            try {
                this.matchValue = this.delegate.apply(input);
                this.match = true;
                return this.matchValue;
            }
            catch (RuntimeException ex) {
                this.thrownExceptionMatch = ex;
                throw ex;
            }
            catch (Error err) {
                this.thrownErrorMatch = err;
                throw err;
            }
        }

        public void setDelegate(DELEGATE delegate) {
            this.delegate = delegate;
        }

        public boolean isMatched() {
            return this.match || this.thrownErrorMatch != null | this.thrownExceptionMatch != null;
        }
    }
}

