/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.BaseResponsePromise;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class WrappingBaseResponsePromise<V>
implements BaseResponsePromise<V> {
    private final Promise<V> delegate;
    private final Set<Integer> statuses;
    private final Set<StatusSet> statusSets;

    public WrappingBaseResponsePromise(ListenableFuture<V> delegate) {
        this.delegate = Promises.forListenableFuture(delegate);
        this.statuses = Sets.newHashSet();
        this.statusSets = Sets.newHashSet();
    }

    @Override
    public BaseResponsePromise<V> done(Effect<V> callback) {
        this.delegate.done(callback);
        return this;
    }

    @Override
    public BaseResponsePromise<V> fail(Effect<Throwable> callback) {
        this.delegate.fail(callback);
        return this;
    }

    @Override
    public BaseResponsePromise<V> then(FutureCallback<V> callback) {
        this.delegate.then(callback);
        return this;
    }

    public V claim() {
        return (V)this.delegate.claim();
    }

    public <B> Promise<B> map(Function<? super V, ? extends B> function) {
        return this.delegate.map(function);
    }

    public <B> Promise<B> flatMap(Function<? super V, Promise<B>> function) {
        return this.delegate.flatMap(function);
    }

    public Promise<V> recover(Function<Throwable, ? extends V> handleThrowable) {
        return this.delegate.recover(handleThrowable);
    }

    public <B> Promise<B> fold(Function<Throwable, ? extends B> handleThrowable, Function<? super V, ? extends B> function) {
        return this.delegate.fold(handleThrowable, function);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    public boolean cancel(boolean b) {
        return this.delegate.cancel(b);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate.get();
    }

    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate.get(l, timeUnit);
    }

    @Override
    public final BaseResponsePromise<V> on(int statusCode, Effect<V> callback) {
        this.statuses.add(statusCode);
        this.done((Effect)this.newStatusSelector(statusCode, callback));
        return this;
    }

    @Override
    public final BaseResponsePromise<V> informational(Effect<V> callback) {
        return this.onRange(100, 200, callback);
    }

    @Override
    public final BaseResponsePromise<V> successful(Effect<V> callback) {
        return this.onRange(200, 300, callback);
    }

    @Override
    public final BaseResponsePromise<V> ok(Effect<V> callback) {
        return this.on(200, callback);
    }

    @Override
    public final BaseResponsePromise<V> created(Effect<V> callback) {
        return this.on(201, callback);
    }

    @Override
    public final BaseResponsePromise<V> noContent(Effect<V> callback) {
        return this.on(204, callback);
    }

    @Override
    public final BaseResponsePromise<V> redirection(Effect<V> callback) {
        return this.onRange(300, 400, callback);
    }

    @Override
    public final BaseResponsePromise<V> seeOther(Effect<V> callback) {
        return this.on(303, callback);
    }

    @Override
    public final BaseResponsePromise<V> notModified(Effect<V> callback) {
        return this.on(304, callback);
    }

    @Override
    public final BaseResponsePromise<V> clientError(Effect<V> callback) {
        return this.onRange(400, 500, callback);
    }

    @Override
    public final BaseResponsePromise<V> badRequest(Effect<V> callback) {
        return this.on(400, callback);
    }

    @Override
    public final BaseResponsePromise<V> unauthorized(Effect<V> callback) {
        return this.on(401, callback);
    }

    @Override
    public final BaseResponsePromise<V> forbidden(Effect<V> callback) {
        return this.on(403, callback);
    }

    @Override
    public final BaseResponsePromise<V> notFound(Effect<V> callback) {
        return this.on(404, callback);
    }

    @Override
    public final BaseResponsePromise<V> conflict(Effect<V> callback) {
        return this.on(409, callback);
    }

    @Override
    public final BaseResponsePromise<V> serverError(Effect<V> callback) {
        return this.onRange(500, 600, callback);
    }

    @Override
    public final BaseResponsePromise<V> internalServerError(Effect<V> callback) {
        return this.on(500, callback);
    }

    @Override
    public final BaseResponsePromise<V> serviceUnavailable(Effect<V> callback) {
        return this.on(503, callback);
    }

    @Override
    public final BaseResponsePromise<V> error(Effect<V> callback) {
        this.clientError(callback);
        this.serverError(callback);
        return this;
    }

    @Override
    public final BaseResponsePromise<V> notSuccessful(Effect<V> callback) {
        MultiRange multi = new MultiRange(new Range[]{new Range(100, 200), new Range(300, 600)});
        this.statusSets.add(multi);
        this.done((Effect)this.newStatusSetSelector(multi, callback));
        return this;
    }

    @Override
    public final BaseResponsePromise<V> others(Effect<V> callback) {
        this.done((Effect)this.newOthersSelector(this.statuses, this.statusSets, callback));
        return this;
    }

    protected abstract Effect<V> newStatusSelector(int var1, Effect<V> var2);

    protected abstract Effect<V> newStatusSetSelector(StatusSet var1, Effect<V> var2);

    protected abstract Effect<V> newOthersSelector(Set<Integer> var1, Set<StatusSet> var2, Effect<V> var3);

    private BaseResponsePromise<V> onRange(int lower, int upper, Effect<V> callback) {
        Range range = new Range(lower, upper);
        this.statusSets.add(range);
        this.done((Effect)this.newStatusSetSelector(range, callback));
        return this;
    }

    protected static class MultiRange
    implements StatusSet {
        private Range[] ranges;

        private MultiRange(Range ... ranges) {
            this.ranges = ranges;
        }

        @Override
        public boolean contains(int value) {
            for (Range range : this.ranges) {
                if (!range.contains(value)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiRange that = (MultiRange)o;
            return Arrays.equals(this.ranges, that.ranges);
        }

        public int hashCode() {
            return this.ranges != null ? Arrays.hashCode(this.ranges) : 0;
        }
    }

    protected static class Range
    implements StatusSet {
        private final int lowerBoundInclusive;
        private final int upperBoundExclusive;

        private Range(int lowerBoundInclusive, int upperBoundExclusive) {
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.upperBoundExclusive = upperBoundExclusive;
        }

        @Override
        public boolean contains(int value) {
            return value >= this.lowerBoundInclusive && value < this.upperBoundExclusive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.lowerBoundInclusive == range.lowerBoundInclusive && this.upperBoundExclusive == range.upperBoundExclusive;
        }

        public int hashCode() {
            int result = this.lowerBoundInclusive;
            result = 31 * result + this.upperBoundExclusive;
            return result;
        }
    }

    protected static interface StatusSet {
        public boolean contains(int var1);
    }
}

