/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromiseMapFunction;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ResponsePromiseMapFunctionBuilder<O> {
    private final Map<ResponsePromiseMapFunction.StatusRange, Function<Response, ? extends O>> functions = Maps.newHashMap();
    private Function<Response, ? extends O> othersFunction;

    ResponsePromiseMapFunctionBuilder() {
    }

    public ResponsePromiseMapFunctionBuilder<O> informational(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.CONTINUE, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> successful(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.OK, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> ok(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.OK, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> created(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CREATED, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> noContent(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NO_CONTENT, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> redirection(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.MULTIPLE_CHOICES, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> seeOther(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SEE_OTHER, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> notModified(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_MODIFIED, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> clientError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.BAD_REQUEST, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> badRequest(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.BAD_REQUEST, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> unauthorized(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.UNAUTHORIZED, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> forbidden(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.FORBIDDEN, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> notFound(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_FOUND, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> conflict(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CONFLICT, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> serverError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> internalServerError(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> serviceUnavailable(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SERVICE_UNAVAILABLE, f);
    }

    public ResponsePromiseMapFunctionBuilder<O> error(Function<Response, ? extends O> f) {
        this.functions.put(new OrStatusRange(new HundredsStatusRange(HttpStatus.BAD_REQUEST), new HundredsStatusRange(HttpStatus.INTERNAL_SERVER_ERROR)), f);
        return this;
    }

    public ResponsePromiseMapFunctionBuilder<O> notSuccessful(Function<Response, ? extends O> f) {
        this.functions.put(new NotInStatusRange(new HundredsStatusRange(HttpStatus.OK)), f);
        return this;
    }

    public ResponsePromiseMapFunctionBuilder<O> others(Function<Response, ? extends O> f) {
        this.othersFunction = f;
        return this;
    }

    private ResponsePromiseMapFunctionBuilder<O> addSingle(HttpStatus status, Function<Response, ? extends O> f) {
        this.functions.put(new SingleStatusRange(status), f);
        return this;
    }

    private ResponsePromiseMapFunctionBuilder<O> addRange(HttpStatus status, Function<Response, ? extends O> f) {
        this.functions.put(new HundredsStatusRange(status), f);
        return this;
    }

    public Function<? super Response, O> build() {
        return new ResponsePromiseMapFunction<O>(this.functions, this.othersFunction);
    }

    private static final class OrStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange one;
        private final ResponsePromiseMapFunction.StatusRange two;

        private OrStatusRange(ResponsePromiseMapFunction.StatusRange one, ResponsePromiseMapFunction.StatusRange two) {
            this.one = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)one);
            this.two = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)two);
        }

        @Override
        public boolean isIn(int code) {
            return this.one.isIn(code) || this.two.isIn(code);
        }
    }

    private static final class NotInStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange range;

        private NotInStatusRange(ResponsePromiseMapFunction.StatusRange range) {
            this.range = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)range);
        }

        @Override
        public boolean isIn(int code) {
            return !this.range.isIn(code);
        }
    }

    private static final class HundredsStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        private HundredsStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            int diff = code - this.status.code;
            return 0 <= diff && diff < 100;
        }
    }

    private static final class SingleStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        private SingleStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            return this.status.code == code;
        }
    }
}

