/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromiseMapFunctionBuilder;
import com.atlassian.httpclient.api.UnexpectedResponseException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public final class ResponsePromiseMapFunction<O>
implements Function<Response, O> {
    private final Map<StatusRange, Function<Response, ? extends O>> functions;
    private final Function<Response, ? extends O> othersFunction;

    ResponsePromiseMapFunction(Map<StatusRange, Function<Response, ? extends O>> functions, Function<Response, ? extends O> othersFunction) {
        this.functions = ImmutableMap.copyOf(functions);
        this.othersFunction = othersFunction;
    }

    public static <T> ResponsePromiseMapFunctionBuilder<T> builder() {
        return new ResponsePromiseMapFunctionBuilder();
    }

    public static <T> Function<Response, T> newUnexpectedResponseFunction() {
        return new Function<Response, T>(){

            public T apply(@Nullable Response response) {
                throw new UnexpectedResponseException(response);
            }
        };
    }

    public O apply(Response response) {
        final int statusCode = response.getStatusCode();
        Map matchingFunctions = Maps.filterKeys(this.functions, (Predicate)new Predicate<StatusRange>(){

            public boolean apply(StatusRange input) {
                return input.isIn(statusCode);
            }
        });
        if (matchingFunctions.isEmpty()) {
            if (this.othersFunction != null) {
                return (O)this.othersFunction.apply((Object)response);
            }
            throw new IllegalStateException("Could not match any function to status " + statusCode);
        }
        if (matchingFunctions.size() > 1) {
            throw new IllegalStateException("Found multiple functions for status " + statusCode);
        }
        return (O)((Function)Iterables.getLast(matchingFunctions.values())).apply((Object)response);
    }

    static interface StatusRange {
        public boolean isIn(int var1);
    }
}

