/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.PartialFunctions;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.ResponseTransformationException;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;

final class DefaultResponseTransformationBuilder<O>
extends ResponseTransformation.Builder<O> {
    private final Iterable<Function<Response, Option<O>>> stack;
    private final Function<Throwable, ? extends O> failFunction;

    DefaultResponseTransformationBuilder(DefaultResponseTransformationBuilder<O> that, Function<Response, Option<O>> partial) {
        this((Iterable<Function<Response, Option<? extends O>>>)ImmutableList.copyOf((Iterable)Iterables.concat(that.stack, Collections.singleton(partial))), that.failFunction);
    }

    DefaultResponseTransformationBuilder(Iterable<Function<Response, Option<O>>> stack, Function<Throwable, ? extends O> failFunction) {
        this.stack = (Iterable)Preconditions.checkNotNull(stack);
        this.failFunction = (Function)Preconditions.checkNotNull(failFunction);
    }

    DefaultResponseTransformationBuilder() {
        this.stack = Collections.emptyList();
        this.failFunction = DefaultResponseTransformationBuilder.defaultThrowableHandler();
    }

    @Override
    public ResponseTransformation.Builder<O> on(HttpStatus status, Function<Response, ? extends O> f) {
        return this.addSingle(status, f);
    }

    @Override
    public ResponseTransformation.Builder<O> on(int statusCode, Function<Response, ? extends O> f) {
        return this.addSingle(statusCode, f);
    }

    @Override
    public ResponseTransformation.Builder<O> informational(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.CONTINUE, f);
    }

    @Override
    public ResponseTransformation.Builder<O> successful(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformation.Builder<O> ok(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformation.Builder<O> created(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CREATED, f);
    }

    @Override
    public ResponseTransformation.Builder<O> noContent(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NO_CONTENT, f);
    }

    @Override
    public ResponseTransformation.Builder<O> redirection(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.MULTIPLE_CHOICES, f);
    }

    @Override
    public ResponseTransformation.Builder<O> seeOther(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SEE_OTHER, f);
    }

    @Override
    public ResponseTransformation.Builder<O> notModified(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_MODIFIED, f);
    }

    @Override
    public ResponseTransformation.Builder<O> clientError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformation.Builder<O> badRequest(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformation.Builder<O> unauthorized(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.UNAUTHORIZED, f);
    }

    @Override
    public ResponseTransformation.Builder<O> forbidden(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.FORBIDDEN, f);
    }

    @Override
    public ResponseTransformation.Builder<O> notFound(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_FOUND, f);
    }

    @Override
    public ResponseTransformation.Builder<O> conflict(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CONFLICT, f);
    }

    @Override
    public ResponseTransformation.Builder<O> serverError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformation.Builder<O> internalServerError(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformation.Builder<O> serviceUnavailable(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SERVICE_UNAVAILABLE, f);
    }

    @Override
    public ResponseTransformation.Builder<O> error(Function<Response, ? extends O> f) {
        return this.append((Predicate<Response>)Predicates.or(this.matchesRange(HttpStatus.BAD_REQUEST), this.matchesRange(HttpStatus.INTERNAL_SERVER_ERROR)), f);
    }

    @Override
    public ResponseTransformation.Builder<O> notSuccessful(Function<Response, ? extends O> f) {
        return this.append((Predicate<Response>)Predicates.not(this.matchesRange(HttpStatus.OK)), f);
    }

    @Override
    public ResponseTransformation.Builder<O> others(Function<Response, ? extends O> f) {
        return this.append((Predicate<Response>)Predicates.alwaysTrue(), f);
    }

    @Override
    public ResponseTransformation.Builder<O> otherwise(Function<Throwable, O> callback) {
        return new DefaultResponseTransformationBuilder<O>(this.stack, callback);
    }

    @Override
    public ResponseTransformation.Builder<O> done(final Function<Response, O> f) {
        return this.others(new Function<Response, O>(){

            public O apply(@Nullable Response input) {
                return f.apply((Object)input);
            }
        });
    }

    @Override
    public ResponseTransformation.Builder<O> fail(Function<Throwable, ? extends O> f) {
        return new DefaultResponseTransformationBuilder<O>(this.stack, f);
    }

    @Override
    public ResponseTransformation<O> build() {
        return new ResponseTransformation<O>(){
            private final Function<Response, O> success;
            {
                this.success = PartialFunctions.compose(DefaultResponseTransformationBuilder.this.stack);
            }

            @Override
            public Promise<O> transform(Promise<Response> promise) {
                return promise.fold(DefaultResponseTransformationBuilder.this.failFunction, this.success);
            }
        };
    }

    ResponseTransformation.Builder<O> addSingle(HttpStatus status, Function<Response, ? extends O> f) {
        return this.addSingle(status.code, f);
    }

    ResponseTransformation.Builder<O> addSingle(int statusCode, Function<Response, ? extends O> f) {
        return this.append(this.matchesStatus(statusCode), f);
    }

    ResponseTransformation.Builder<O> addRange(HttpStatus status, Function<Response, ? extends O> f) {
        return this.append(this.matchesRange(status), f);
    }

    ResponseTransformation.Builder<O> append(Predicate<Response> p, Function<Response, ? extends O> f) {
        return this.copy(PartialFunctions.from(p, f));
    }

    ResponseTransformation.Builder<O> copy(Function<Response, Option<O>> f) {
        return new DefaultResponseTransformationBuilder<O>(this, f);
    }

    Predicate<Response> matchesStatus(final int code) {
        return new StatusCodePredicate((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return code == input;
            }
        });
    }

    Predicate<Response> matchesRange(final HttpStatus status) {
        return new StatusCodePredicate((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer input) {
                int diff = input - status.code;
                return 0 <= diff && diff < 100;
            }
        });
    }

    private static <A> Function<Throwable, ? extends A> defaultThrowableHandler() {
        return new Function<Throwable, A>(){

            public A apply(Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new ResponseTransformationException(throwable);
            }
        };
    }

    static final class StatusCodePredicate
    implements Predicate<Response> {
        private final Predicate<Integer> p;

        private StatusCodePredicate(Predicate<Integer> p) {
            this.p = (Predicate)Preconditions.checkNotNull(p);
        }

        public boolean apply(Response input) {
            return this.p.apply((Object)input.statusCode());
        }
    }
}

