/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    private static final String UNKNOWN_VERSION = "unknown";

    MavenUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getVersion(String groupId, String artifactId) {
        Properties props = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = MavenUtils.class.getResourceAsStream(String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
            props.load(resourceAsStream);
            String string = props.getProperty("version", UNKNOWN_VERSION);
            return string;
        }
        catch (Exception e) {
            logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
            logger.debug("Got the following exception", (Throwable)e);
            String string = UNKNOWN_VERSION;
            return string;
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

