/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.http.mime;

import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.http.mime.DownloadPolicy;
import com.atlassian.http.mime.DownloadPolicyProvider;
import com.atlassian.http.mime.HostileExtensionDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDispositionHeaderGuesser {
    private static final Logger log = LoggerFactory.getLogger(ContentDispositionHeaderGuesser.class);
    private static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String CONTENT_DISPOSITION_INLINE = "inline";
    private final DownloadPolicyProvider downloadPolicyProvider;
    private final HostileExtensionDetector hostileExtensionDetector;

    public ContentDispositionHeaderGuesser(DownloadPolicyProvider downloadPolicyProvider, HostileExtensionDetector hostileExtensionDetector) {
        this.downloadPolicyProvider = downloadPolicyProvider;
        this.hostileExtensionDetector = hostileExtensionDetector;
    }

    public String guessContentDispositionHeader(String fileName, String mimeContentType, String userAgent) {
        DownloadPolicy downloadPolicy = this.downloadPolicyProvider.getPolicy();
        boolean forceDownload = false;
        if (downloadPolicy != DownloadPolicy.Insecure && this.isExecutableContent(fileName, mimeContentType)) {
            forceDownload = true;
            if (log.isDebugEnabled()) {
                log.debug("\"" + fileName + "\" (" + mimeContentType + ")" + " presents as executable content, forcing download.");
            }
        } else if (downloadPolicy == DownloadPolicy.Secure) {
            forceDownload = true;
        }
        if (forceDownload && this.isAllowInlineOverride(fileName, mimeContentType, userAgent, downloadPolicy)) {
            forceDownload = false;
        }
        return forceDownload ? CONTENT_DISPOSITION_ATTACHMENT : CONTENT_DISPOSITION_INLINE;
    }

    public String guessMIME(String filename, String mimeContentType, String userAgent) {
        if (CONTENT_DISPOSITION_INLINE.equals(this.guessContentDispositionHeader(filename, mimeContentType, userAgent)) && this.isAllowInlineOverride(filename, mimeContentType, userAgent, this.downloadPolicyProvider.getPolicy())) {
            return "text/plain";
        }
        return mimeContentType;
    }

    private boolean isAllowInlineOverride(String fileName, String mimeContentType, String userAgent, DownloadPolicy downloadPolicy) {
        return downloadPolicy == DownloadPolicy.Smart && !BrowserUtils.isIE(userAgent) && this.isTextContent(fileName, mimeContentType);
    }

    private boolean isTextContent(String fileName, String mimeContentType) {
        return this.hostileExtensionDetector.isTextContent(fileName, mimeContentType);
    }

    private boolean isExecutableContent(String name, String mimeContentType) {
        return this.hostileExtensionDetector.isExecutableContent(name, mimeContentType);
    }
}

