/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.http.mime;

import com.atlassian.http.mime.UserAgentUtil;
import com.atlassian.http.mime.UserAgentUtilImpl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUtils {
    private static final Logger log = LoggerFactory.getLogger(BrowserUtils.class);

    public static boolean isIE8OrGreater(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return false;
        }
        UserAgentUtil.Browser browser = BrowserUtils.getBrowserObject(userAgent);
        return browser.getBrowserFamily() == UserAgentUtil.BrowserFamily.MSIE && browser.getBrowserMajorVersion().compareTo(UserAgentUtil.BrowserMajorVersion.MSIE7) > 1;
    }

    public static boolean isIE(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return false;
        }
        return BrowserUtils.getBrowserObject(userAgent).getBrowserFamily() == UserAgentUtil.BrowserFamily.MSIE;
    }

    private static UserAgentUtil.Browser getBrowserObject(String userAgent) {
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getBrowser();
    }
}

