/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.test;

import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class HazelcastTestUtils {
    public static IAtomicLong mockAtomicLong() {
        return HazelcastTestUtils.createDelegatingMock(IAtomicLong.class, new AtomicLong());
    }

    public static <E> IAtomicReference<E> mockAtomicReference() {
        return HazelcastTestUtils.createDelegatingMock(IAtomicReference.class, new AtomicReference());
    }

    public static <K, V> IMap<K, V> mockIMap(Class<K> keyClass, final Class<V> valueClass) {
        final ConcurrentHashMap backingMap = new ConcurrentHashMap();
        IMap mock = HazelcastTestUtils.createDelegatingMock(IMap.class, backingMap);
        Mockito.when((Object)mock.executeOnKey(Matchers.any(keyClass), (EntryProcessor)Matchers.any(EntryProcessor.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                final Object key = invocation.getArguments()[0];
                EntryProcessor processor = (EntryProcessor)invocation.getArguments()[1];
                Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
                Mockito.when(entry.getKey()).thenReturn(key);
                Mockito.when(entry.getValue()).thenReturn(backingMap.get(key));
                Mockito.when((Object)entry.setValue(Matchers.any((Class)valueClass))).thenAnswer((Answer)new Answer<Object>(){

                    public Object answer(InvocationOnMock invocation) throws Throwable {
                        Object value = invocation.getArguments()[0];
                        if (value == null) {
                            return backingMap.remove(key);
                        }
                        return backingMap.put(key, value);
                    }
                });
                return processor.process(entry);
            }
        });
        return mock;
    }

    private static <T> T createDelegatingMock(Class<T> proxyType, final Object realTarget) {
        return (T)Mockito.mock(proxyType, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                try {
                    Method method = realTarget.getClass().getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
                    return method.invoke(realTarget, invocation.getArguments());
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }
}

