/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.test;

import com.atlassian.hazelcast.test.DefaultNodeConfigurer;
import com.atlassian.hazelcast.test.NodeConfigurer;
import com.atlassian.hazelcast.test.StandaloneNodeConfigurer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.rules.ExternalResource;

public class HazelcastCluster
extends ExternalResource {
    public static String PROP_INDEX = "node-index";
    private final NodeConfigurer configurer;
    private final List<HazelcastInstance> nodes;
    private final int initialSize;
    private final int totalSize;
    private TestHazelcastInstanceFactory factory;

    protected HazelcastCluster(AbstractBuilder builder) {
        this.configurer = builder.configurer;
        this.initialSize = builder.initialSize;
        this.totalSize = builder.maxSize;
        this.nodes = new ArrayList<HazelcastInstance>(this.totalSize);
    }

    public static int getNodeIndex(HazelcastInstance node) {
        String indexProperty = node.getConfig().getProperty(PROP_INDEX);
        if (indexProperty == null) {
            return -1;
        }
        try {
            return Integer.parseInt(indexProperty);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String generateKeyOwnedByNode(int index) {
        String key;
        Member keyOwner;
        HazelcastInstance node = this.getNode(index);
        do {
            key = UUID.randomUUID().toString();
        } while ((keyOwner = node.getPartitionService().getPartition((Object)key).getOwner()) == null || !keyOwner.equals(node.getCluster().getLocalMember()));
        return key;
    }

    public HazelcastInstance getNode(int index) {
        return this.nodes.get(index);
    }

    public List<HazelcastInstance> getNodes() {
        return ImmutableList.copyOf(this.nodes);
    }

    public void reset() {
        for (HazelcastInstance node : this.nodes) {
            this.resetNode(node);
        }
    }

    protected void after() {
        try {
            for (HazelcastInstance node : this.nodes) {
                this.tearDownNode(node);
            }
            this.factory.shutdownAll();
            this.factory = null;
            this.nodes.clear();
        }
        finally {
            super.after();
        }
    }

    protected void before() throws Throwable {
        super.before();
        this.factory = new TestHazelcastInstanceFactory(this.totalSize);
        for (int i = 0; i < this.initialSize; ++i) {
            this.addNode();
        }
    }

    public synchronized HazelcastInstance addNode() {
        Preconditions.checkState((this.nodes.size() < this.totalSize ? 1 : 0) != 0, (Object)("All " + this.totalSize + " nodes have already been added."));
        Config config = this.createConfig(this.nodes.size());
        HazelcastInstance instance = this.factory.newHazelcastInstance(config);
        this.setupNode(instance);
        this.nodes.add(instance);
        return instance;
    }

    protected Config createConfig(int nodeIndex) {
        return this.configurer.createConfig(this.nodes.size()).setProperty(PROP_INDEX, Integer.toString(nodeIndex));
    }

    protected void resetNode(HazelcastInstance node) {
        this.configurer.onReset(node);
        for (DistributedObject object : node.getDistributedObjects()) {
            object.destroy();
        }
    }

    protected void setupNode(HazelcastInstance node) {
        this.configurer.postCreate(node);
    }

    protected void tearDownNode(HazelcastInstance node) {
        this.configurer.preDestroy(node);
    }

    static {
        System.setProperty("hazelcast.logging.type", "slf4j");
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder, C extends HazelcastCluster> {
        protected NodeConfigurer configurer = new DefaultNodeConfigurer();
        protected int initialSize = 1;
        protected int maxSize = 1;

        protected AbstractBuilder() {
        }

        public abstract C build();

        public B nodeConfigurer(NodeConfigurer value) {
            this.configurer = (NodeConfigurer)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this.self();
        }

        public B size(int value) {
            return this.size(value, value);
        }

        public B size(int initial, int max) {
            Preconditions.checkArgument((initial >= 0 ? 1 : 0) != 0, (Object)"initial must be positive");
            Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"max must be positive");
            Preconditions.checkArgument((max >= initial ? 1 : 0) != 0, (Object)"max must be equal to or greater than initial");
            this.initialSize = initial;
            this.maxSize = max;
            return this.self();
        }

        public B standalone() {
            return this.nodeConfigurer(new StandaloneNodeConfigurer());
        }

        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder, HazelcastCluster> {
        @Override
        public HazelcastCluster build() {
            return new HazelcastCluster(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

