/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.micrometer;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.Collections;

final class MembershipMetricsListener
implements MembershipListener {
    private static final String METER_PREFIX = "hazelcast.membership.";
    private final MeterRegistry meterRegistry;

    MembershipMetricsListener(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void memberAdded(MembershipEvent event) {
        this.incrementCounter("memberAdded", this.tags(event));
        this.updateMemberCount(event);
    }

    public void memberRemoved(MembershipEvent event) {
        this.incrementCounter("memberRemoved", this.tags(event));
        this.updateMemberCount(event);
    }

    private void incrementCounter(String meterName, Collection<Tag> tags) {
        this.meterRegistry.counter(METER_PREFIX + meterName, tags).increment();
    }

    private void updateMemberCount(MembershipEvent event) {
        this.meterRegistry.gauge("hazelcast.membership.memberCount", this.tags(event), (Number)event.getMembers().size());
    }

    private Collection<Tag> tags(MembershipEvent event) {
        return Collections.singletonList(Tag.of((String)"memberAddress", (String)String.valueOf(event.getMember().getAddress())));
    }
}

