package com.atlassian.h2;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.LazyReference;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import java.io.File;

import static java.util.Objects.requireNonNull;

/**
 * Creates a database directory in the application's home directory.
 */
@ThreadSafe
public class DatabaseHomeDirectory extends LazyReference<File> {
    private final AtlassianBootstrapManager bootstrapManager;
    private final String databaseDirectoryName;

    public DatabaseHomeDirectory(@Nonnull final AtlassianBootstrapManager bootstrapManager, @Nonnull String databaseDirectoryName) {
        this.bootstrapManager = requireNonNull(bootstrapManager);
        this.databaseDirectoryName = requireNonNull(databaseDirectoryName);
    }

    @Nonnull
    @Override
    protected File create() {
        final File databaseDirectory = new File(new File(bootstrapManager.getApplicationHome()), databaseDirectoryName);
        if (!databaseDirectory.exists()) {
            Preconditions.checkState(databaseDirectory.mkdirs(), "failed to create directory %s", databaseDirectory);
        }
        Preconditions.checkState(databaseDirectory.isDirectory(), "%s is not a directory", databaseDirectory);
        return databaseDirectory;
    }
}
