package com.atlassian.h2;

import com.google.common.base.Preconditions;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import java.io.File;
import java.util.function.Function;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Specifies a database to be created on connection.
 */
@ThreadSafe
public class DatabaseCreatingClientConfig implements Function<ServerView, String> {

    private final Supplier<File> databaseDirectory;
    private final String databaseName;
    private final boolean useMVCC;

    /**
     * @deprecated since 2.1.0, use {@link #DatabaseCreatingClientConfig(Supplier, String, boolean)}
     */
    @Deprecated
    public DatabaseCreatingClientConfig(@Nonnull final Supplier<File> databaseDirectory, @Nonnull final String databaseName) {
        this(databaseDirectory, databaseName, true);
    }

    /**
     * as of h2 1.4.200 the MVCC setting is no longer supported
     *
     * @since 2.1.0
     */
    public DatabaseCreatingClientConfig(@Nonnull final Supplier<File> databaseDirectory,
                                        @Nonnull final String databaseName,
                                        final boolean useMVCC) {
        this.databaseDirectory = requireNonNull(databaseDirectory);
        this.databaseName = requireNonNull(databaseName);
        this.useMVCC = useMVCC;
    }

    @Nonnull
    @Override
    public String apply(@Nonnull final ServerView server) {
        requireNonNull(server);
        Preconditions.checkState(server.isRunning(), "expected %s to be running", server);
        final File databaseFile = new File(databaseDirectory.get(), databaseName);
        return server.getUri() + "/" + databaseFile.getAbsolutePath() + (useMVCC ? ";MVCC=TRUE" : "");
    }
}
