package com.atlassian.h2;

import io.atlassian.fugue.Pair;
import org.h2.engine.Constants;
import org.h2.tools.Server;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

/**
 * This configuration alone is not satisfactory, the server must either be configured with databases or should allow clients to create databases.
 */
@NotThreadSafe
public abstract class AbstractServerConfig implements Supplier<Server> {
    @Nonnull
    private Pair<Integer, Boolean> port = new Pair<>(Constants.DEFAULT_TCP_PORT, Boolean.FALSE);
    @Nullable
    private Supplier<File> databaseDirectory;

    public AbstractServerConfig setPort(final int port, final boolean required) {
        this.port = new Pair<>(port, required);
        return this;
    }

    public AbstractServerConfig setDatabaseHomeDirectory(@Nonnull Supplier<File> databaseDirectory) {
        this.databaseDirectory = databaseDirectory;
        return this;
    }

    @Nonnull
    @Override
    public Server get() {
        final List<String> options = getOptions();

        try {
            return Server.createTcpServer(options.toArray(new String[options.size()]));
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }

    }

    @Nonnull
    protected List<String> getOptions() {
        final List<String> options = new ArrayList<>();

        // specify a port only if required
        if (port.right()) {
            options.add("-tcpPort");
            options.add(port.left().toString());
        }
        if (databaseDirectory != null) {
            options.add("-baseDir");
            options.add(databaseDirectory.get().getAbsolutePath());
        }

        return options;
    }
}
