/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.h2;

import com.atlassian.h2.ServerView;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DatabaseCreatingClientConfig
implements Function<ServerView, String> {
    private final Supplier<File> databaseDirectory;
    private final String databaseName;

    public DatabaseCreatingClientConfig(Supplier<File> databaseDirectory, String databaseName) {
        this.databaseDirectory = databaseDirectory;
        this.databaseName = databaseName;
    }

    public String apply(@Nullable ServerView server) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkState((boolean)server.isRunning(), (String)"expected %s to be running", (Object[])new Object[]{server});
        File databaseFile = new File((File)this.databaseDirectory.get(), this.databaseName);
        return server.getUri() + "/" + databaseFile.getAbsolutePath() + ";MVCC=TRUE";
    }
}

