/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.plugins.PluginGadgetSpec;
import com.atlassian.gadgets.util.Uri;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GadgetSpecUrlBuilder {
    public static final Pattern GADGET_SPEC_URL_PATTERN = Pattern.compile("([^/:]+)(?::[^/:]+)?/(.+)");
    private final ApplicationProperties applicationProperties;

    @Autowired
    public GadgetSpecUrlBuilder(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    public String appendBaseGadgetSpecUrl(String gadgetSpecUrl) {
        String baseUrl = this.getBaseGadgetSpecUrl();
        return gadgetSpecUrl.startsWith(baseUrl) ? gadgetSpecUrl : baseUrl + gadgetSpecUrl;
    }

    public String buildGadgetSpecFeedUrl() {
        return this.applicationProperties.getBaseUrl() + "/" + this.getBaseGadgetSpecUrl() + "feed";
    }

    public String buildGadgetSpecUrl(PluginGadgetSpec gadget) {
        Preconditions.checkNotNull((Object)gadget, (Object)"pluginGadgetSpec");
        return gadget.getPublishLocation() == null ? this.buildGadgetSpecUrl(gadget.getPluginKey(), gadget.getModuleKey(), gadget.getLocation()) : this.appendBaseGadgetSpecUrl(gadget.getPublishLocation());
    }

    public String buildGadgetSpecUrl(String pluginKey, String moduleKey, String location) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        Preconditions.checkNotNull((Object)moduleKey, (Object)"moduleKey");
        Preconditions.checkNotNull((Object)location, (Object)"location");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseGadgetSpecUrl());
        sb.append(Uri.encodeUriComponent(pluginKey));
        sb.append(':');
        sb.append(Uri.encodeUriComponent(moduleKey));
        for (String component : location.split("\\/")) {
            sb.append('/');
            sb.append(Uri.encodeUriComponent(component));
        }
        return sb.toString();
    }

    public PluginGadgetSpec.Key parseGadgetSpecUrl(String gadgetSpecUrl) {
        Preconditions.checkNotNull((Object)gadgetSpecUrl, (Object)"gadgetSpecUrl");
        Matcher validGadgetSpecUrlMatcher = this.validGadgetSpecUrlPattern().matcher(gadgetSpecUrl);
        if (!validGadgetSpecUrlMatcher.matches()) {
            throw new GadgetSpecUriNotAllowedException("URL is not a gadget spec URL for this server " + gadgetSpecUrl);
        }
        String pluginKey = Uri.decodeUriComponent(validGadgetSpecUrlMatcher.group(1));
        String location = Uri.decodeUriComponent(validGadgetSpecUrlMatcher.group(2));
        return new PluginGadgetSpec.Key(pluginKey, location);
    }

    private String getBaseGadgetSpecUrl() {
        return "rest/gadgets/1.0/g/";
    }

    private Pattern validGadgetSpecUrlPattern() {
        return Pattern.compile("(?:" + Pattern.quote(this.applicationProperties.getBaseUrl()) + "/)?" + Pattern.quote(this.getBaseGadgetSpecUrl()) + GADGET_SPEC_URL_PATTERN);
    }
}

