/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.oauth;

import com.atlassian.oauth.Request;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.bridge.Requests;
import com.atlassian.oauth.bridge.ServiceProviders;
import com.atlassian.oauth.bridge.consumer.ConsumerTokens;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import java.util.List;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.OAuthFetcher;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;

public class AtlassianOAuthFetcher
extends OAuthFetcher {
    private final ConsumerService consumerService;

    public AtlassianOAuthFetcher(@ComponentImport ConsumerService consumerService, OAuthFetcherConfig fetcherConfig, HttpFetcher nextFetcher, HttpRequest request) {
        super(fetcherConfig, nextFetcher);
        this.consumerService = consumerService;
    }

    protected OAuthMessage sign(OAuthAccessor accessor, String httpMethod, String uri, List<OAuth.Parameter> params) throws OAuthException {
        Request request = new Request(Request.HttpMethod.valueOf((String)httpMethod.toUpperCase()), URI.create(uri), Requests.fromOAuthParameters(params));
        ServiceProvider serviceProvider = ServiceProviders.fromOAuthServiceProvider((OAuthServiceProvider)accessor.consumer.serviceProvider);
        if (accessor.requestToken != null || accessor.accessToken != null) {
            ConsumerToken token = ConsumerTokens.asConsumerToken((OAuthAccessor)accessor);
            return Requests.asOAuthMessage((Request)this.consumerService.sign(request, serviceProvider, token));
        }
        return Requests.asOAuthMessage((Request)this.consumerService.sign(request, accessor.consumer.consumerKey, serviceProvider));
    }
}

