/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;

public class AppLinksWhitelist
implements Whitelist {
    private final ApplicationLinkService appLinkService;

    public AppLinksWhitelist(ApplicationLinkService appLinkService) {
        this.appLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)appLinkService, (Object)"appLinkService");
    }

    public boolean allows(URI uri) {
        return Iterables.any(this.appLinks(), this.prefixes((URI)Preconditions.checkNotNull((Object)uri, (Object)"uri")));
    }

    private Iterable<URI> appLinks() {
        return Iterables.transform((Iterable)this.appLinkService.getApplicationLinks(), this.rpcUri());
    }

    private Function<ApplicationLink, URI> rpcUri() {
        return ExtractRpcUri.INSTANCE;
    }

    private Predicate<URI> prefixes(URI uri) {
        return new UriPrefixPredicate(uri);
    }

    private static final class UriPrefixPredicate
    implements Predicate<URI> {
        private final String uri;

        public UriPrefixPredicate(URI uri) {
            this.uri = uri.normalize().toASCIIString().toLowerCase();
        }

        public boolean apply(URI prefix) {
            return this.uri.startsWith(prefix.normalize().toASCIIString().toLowerCase());
        }
    }

    private static enum ExtractRpcUri implements Function<ApplicationLink, URI>
    {
        INSTANCE;


        public URI apply(ApplicationLink appLink) {
            return appLink.getRpcUrl();
        }
    }
}

