/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.opensocial.internal;

import com.atlassian.gadgets.opensocial.OpenSocialRequestContext;
import com.atlassian.gadgets.opensocial.internal.ShindigOpenSocialTypeAdapter;
import com.atlassian.gadgets.opensocial.model.AppId;
import com.atlassian.gadgets.opensocial.model.Person;
import com.atlassian.gadgets.opensocial.model.PersonId;
import com.atlassian.gadgets.opensocial.spi.AppDataServiceException;
import com.atlassian.gadgets.opensocial.spi.PersonService;
import com.atlassian.gadgets.util.Uri;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShindigAppDataServiceImpl
implements AppDataService {
    private final com.atlassian.gadgets.opensocial.spi.AppDataService appDataService;
    private final PersonService personService;
    private final TransactionTemplate txTemplate;
    private final ApplicationProperties applicationProperties;
    private static final String ALL_FIELDS_KEY = "*";

    @Autowired
    public ShindigAppDataServiceImpl(com.atlassian.gadgets.opensocial.spi.AppDataService appDataService, PersonService personService, TransactionTemplate txTemplate, ApplicationProperties applicationProperties) {
        this.appDataService = appDataService;
        this.personService = personService;
        this.txTemplate = txTemplate;
        this.applicationProperties = applicationProperties;
    }

    public Future<DataCollection> getPersonData(final Set<UserId> userIds, final GroupId groupId, String appId, final Set<String> fields, final SecurityToken token) throws SocialSpiException {
        try {
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            Map peopleData = (Map)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Set<PersonId> people = ShindigOpenSocialTypeAdapter.getPeopleIdsFromUserIds(ShindigAppDataServiceImpl.this.personService, userIds, groupId, token);
                    OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
                    if (fields.contains(ShindigAppDataServiceImpl.ALL_FIELDS_KEY) || fields.isEmpty()) {
                        return ShindigAppDataServiceImpl.this.appDataService.getPeopleData(people, relativeAppId, openSocialRequestContext);
                    }
                    return ShindigAppDataServiceImpl.this.appDataService.getPeopleData(people, relativeAppId, fields, openSocialRequestContext);
                }
            });
            HashMap resolvedPeopleData = new HashMap();
            for (Map.Entry personData : peopleData.entrySet()) {
                if (((Map)personData.getValue()).isEmpty()) continue;
                resolvedPeopleData.put(((PersonId)personData.getKey()).toString(), personData.getValue());
            }
            return ImmediateFuture.newInstance((Object)new DataCollection(resolvedPeopleData));
        }
        catch (AppDataServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> deletePersonData(final UserId userId, GroupId groupId, String appId, final Set<String> fields, final SecurityToken token) throws SocialSpiException {
        try {
            final OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Person person = ShindigAppDataServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    if (person != null) {
                        if (fields.contains(ShindigAppDataServiceImpl.ALL_FIELDS_KEY) || fields.isEmpty()) {
                            ShindigAppDataServiceImpl.this.appDataService.deletePersonData(person.getPersonId(), relativeAppId, openSocialRequestContext);
                        } else {
                            ShindigAppDataServiceImpl.this.appDataService.deletePersonData(person.getPersonId(), relativeAppId, fields, openSocialRequestContext);
                        }
                    }
                    return null;
                }
            });
            return ImmediateFuture.newInstance(null);
        }
        catch (AppDataServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> updatePersonData(final UserId userId, GroupId groupId, String appId, Set<String> fields, final Map<String, String> values, final SecurityToken token) throws SocialSpiException {
        try {
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
                    Person person = ShindigAppDataServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    if (person != null) {
                        ShindigAppDataServiceImpl.this.appDataService.updatePersonData(person.getPersonId(), relativeAppId, values, openSocialRequestContext);
                    }
                    return null;
                }
            });
            return ImmediateFuture.newInstance(null);
        }
        catch (AppDataServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }
}

