AJS.test.require([
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.directory:gadget-directory-admin-client"
], function(){
    module("External gadget controller test", {
        setup: function() {
            var $page = AJS.$("<div><form id='add-stuff'><input type='text' id='gadget-url'/><input type='submit' /><aui-spinner class='add-spinner'></aui-spinner></form></div>");
            AJS.$("#qunit-fixture").append($page);

            this.server = sinon.fakeServer.create();

            this.$userInput = AJS.$("#gadget-url");
            this.$addForm = AJS.$("#add-stuff");
            this.windowStub = {
                location: {
                    reload: function() {}
                },
                alert: function(msg) {}
            };
            this.reloadSpy = sinon.spy(this.windowStub.location, "reload");
            this.alertSpy = sinon.spy(this.windowStub, "alert");
        },

        teardown: function() {
            this.server.restore();
            this.reloadSpy.restore();
            this.alertSpy.restore();
        }
    });

    test("Should make a REST call when add button is clicked", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);

        this.$addForm.trigger("submit");

        equal(this.server.requests.length, 1);
    });

    test("Should pass user input as request parameter when a transform is not specified", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);
        this.$userInput.val("gadget-url");

        this.$addForm.trigger("submit");

        var requestBody = eval("(" + this.server.requests[0].requestBody + ")");
        equal(requestBody["url"], "gadget-url");
    });

    test("Should pass transformed user input as request parameter when a transform is specified", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub, function(userInput) {
                return userInput.toUpperCase();
            });
        this.$userInput.val("gadget-url");

        this.$addForm.trigger("submit");

        var requestBody = eval("(" + this.server.requests[0].requestBody + ")");
        equal(requestBody["url"], "GADGET-URL");
    });

    test("Should disable add button when add request is in progress", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);

        this.$addForm.trigger("submit");

        ok(this.$addForm.find(":input").prop("disabled") === true);
    });

    test("Should reload page when add request succeeded", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);
        this.$addForm.trigger("submit");

        this.server.requests[0].respond(200, {"Content-Type": "application/json"}, "[]");

        ok(this.reloadSpy.calledOnce);
    });

    test("Should pop up an alert when add request failed", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);
        this.$addForm.trigger("submit");

        this.server.requests[0].respond(500);

        ok(this.alertSpy.calledOnce);
        ok(this.alertSpy.calledWith("error-message"))
    });

    test("Should enable add button when add request failed", function(){
        this.controller = new GadgetDirectoryAdminAddController(this.$userInput, this.$addForm,
            "error-message", this.windowStub);
        this.$addForm.trigger("submit");

        this.server.requests[0].respond(500);

        ok(this.$addForm.find(":input").prop("disabled") === false);
    });
});
