/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.rest;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.jaxb.DashboardItemRepresentation;
import com.atlassian.gadgets.directory.internal.jaxb.DashboardItemRepresentationFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/directoryitems")
public class DirectoryItemResource {
    private final Directory directory;
    private final GadgetRequestContextFactory gadgetReqCtxFactory;
    private final DashboardItemRepresentationFactory dashboardItemRepresentationFactory;

    public DirectoryItemResource(Directory directory, @ComponentImport GadgetRequestContextFactory gadgetReqCtxFactory, DashboardItemRepresentationFactory dashboardItemRepresentationFactory) {
        this.directory = directory;
        this.gadgetReqCtxFactory = gadgetReqCtxFactory;
        this.dashboardItemRepresentationFactory = dashboardItemRepresentationFactory;
    }

    @GET
    @Path(value="/")
    @AnonymousAllowed
    @Produces(value={"application/xml", "application/json"})
    public Response getAllDashboardItems(@Context HttpServletRequest request) {
        return this.getDashboardItems(request, Directory.EntryScope.ALL);
    }

    @GET
    @Path(value="/local")
    @AnonymousAllowed
    @Produces(value={"application/xml", "application/json"})
    public Response getLocalDashboardItems(@Context HttpServletRequest request) {
        return this.getDashboardItems(request, Directory.EntryScope.LOCAL);
    }

    @GET
    @Path(value="/external")
    @AnonymousAllowed
    @Produces(value={"application/xml", "application/json"})
    public Response getExternalDashboardItems(@Context HttpServletRequest request) {
        return this.getDashboardItems(request, Directory.EntryScope.EXTERNAL);
    }

    private Response getDashboardItems(HttpServletRequest request, Directory.EntryScope entryScope) {
        GadgetRequestContext gadgetReqCtx = this.gadgetReqCtxFactory.get(request);
        Iterable entries = this.directory.getEntries(gadgetReqCtx, entryScope);
        Iterable items = Iterables.transform((Iterable)entries, (Function)new Function<Directory.Entry<?>, DashboardItemRepresentation>(){

            public DashboardItemRepresentation apply(Directory.Entry<?> entry) {
                return DirectoryItemResource.this.dashboardItemRepresentationFactory.createDashboardItemRepresentation(entry);
            }
        });
        return Response.ok((Object)items).build();
    }
}

