/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.velocity;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.internal.rest.representations.UserPrefRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.UserPrefsRepresentation;
import com.atlassian.gadgets.dashboard.internal.util.JavaScript;
import com.atlassian.templaterenderer.annotations.HtmlSafe;
import com.google.common.base.Preconditions;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardEmbedder {
    private final RepresentationFactory representationFactory;

    @Autowired
    public DashboardEmbedder(RepresentationFactory representationFactory) {
        this.representationFactory = (RepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
    }

    @HtmlSafe
    public String json(Dashboard dashboard, GadgetRequestContext gadgetRequestContext, boolean writable) {
        DashboardRepresentation representation = this.representationFactory.createDashboardRepresentation(dashboard, gadgetRequestContext, writable);
        JSONObject json = new JSONObject();
        try {
            this.put(json, "id", representation.getId());
            this.put(json, "title", representation.getTitle());
            this.put(json, "writable", writable);
            this.put(json, "layout", representation.getLayout().toString());
            if (!representation.getGadgets().isEmpty()) {
                this.put(json, "gadgets", this.gadgetsToJsonArray(representation.getGadgets()));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json.toString();
    }

    private JSONArray gadgetsToJsonArray(List<GadgetRepresentation> gadgets) throws JSONException {
        JSONArray array = new JSONArray();
        for (GadgetRepresentation gadget : gadgets) {
            array.put((Object)this.gadgetToJsonObject(gadget));
        }
        return array;
    }

    private JSONObject gadgetToJsonObject(GadgetRepresentation gadget) throws JSONException {
        JSONObject json = new JSONObject();
        this.put(json, "id", gadget.getId());
        this.put(json, "title", gadget.getTitle());
        this.put(json, "titleUrl", gadget.getTitleUrl());
        this.put(json, "gadgetSpecUrl", gadget.getGadgetSpecUrl());
        this.put(json, "height", gadget.getHeight());
        this.put(json, "width", gadget.getWidth());
        this.put(json, "color", gadget.getColor());
        this.put(json, "column", gadget.getColumn());
        this.put(json, "colorUrl", gadget.getColorUrl());
        this.put(json, "gadgetUrl", gadget.getGadgetUrl());
        this.put(json, "isMaximizable", gadget.isMaximizable());
        this.put(json, "renderedGadgetUrl", gadget.getRenderedGadgetUrl());
        this.put(json, "hasNonHiddenUserPrefs", gadget.getHasNonHiddenUserPrefs());
        this.put(json, "userPrefs", this.userPrefsToJsonObject(gadget.getUserPrefs()));
        this.put(json, "loaded", gadget.isLoaded());
        this.put(json, "errorMessage", gadget.getErrorMessage());
        return json;
    }

    private JSONObject userPrefsToJsonObject(UserPrefsRepresentation userPrefs) throws JSONException {
        if (userPrefs == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        this.put(json, "action", userPrefs.getAction());
        this.put(json, "fields", this.fieldsToJsonArray(userPrefs.getFields()));
        return json;
    }

    private JSONArray fieldsToJsonArray(List<UserPrefRepresentation> fields) throws JSONException {
        JSONArray array = new JSONArray();
        for (UserPrefRepresentation userPref : fields) {
            array.put((Object)this.userPrefToJsonObject(userPref));
        }
        return array;
    }

    private JSONObject userPrefToJsonObject(UserPrefRepresentation userPref) throws JSONException {
        JSONObject json = new JSONObject();
        this.put(json, "name", userPref.getName());
        this.put(json, "value", userPref.getValue());
        this.put(json, "type", userPref.getType());
        this.put(json, "displayName", userPref.getDisplayName());
        this.put(json, "required", userPref.isRequired());
        if (!userPref.getOptions().isEmpty()) {
            this.put(json, "options", this.optionsToJsonArray(userPref.getOptions()));
        }
        return json;
    }

    private JSONArray optionsToJsonArray(List<UserPrefRepresentation.EnumValueRepresentation> options) throws JSONException {
        JSONArray array = new JSONArray();
        for (UserPrefRepresentation.EnumValueRepresentation option : options) {
            array.put((Object)this.optionToJsonObject(option));
        }
        return array;
    }

    private JSONObject optionToJsonObject(UserPrefRepresentation.EnumValueRepresentation option) throws JSONException {
        JSONObject json = new JSONObject();
        this.put(json, "value", option.getValue());
        this.put(json, "label", option.getLabel());
        this.put(json, "selected", option.isSelected());
        return json;
    }

    private void put(JSONObject json, String key, String value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(key, (Object)this.escape(value));
    }

    private void put(JSONObject json, String key, boolean value) throws JSONException {
        json.put(key, value);
    }

    private void put(JSONObject json, String key, Boolean value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(key, (Object)value);
    }

    private void put(JSONObject json, String key, JSONArray array) throws JSONException {
        if (array == null) {
            return;
        }
        json.put(key, (Object)array);
    }

    private void put(JSONObject json, String key, JSONObject value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(key, (Object)value);
    }

    private void put(JSONObject json, String key, Integer value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(key, (Object)value);
    }

    private void put(JSONObject json, String key, Color color) throws JSONException {
        json.put(key, (Object)(color == null ? "" : color.toString()));
    }

    private JSONString escape(String str) {
        return new EscapedJsonString(str);
    }

    private static final class EscapedJsonString
    implements JSONString {
        private final String str;

        public EscapedJsonString(String str) {
            this.str = str;
        }

        public String toJSONString() {
            return '\"' + JavaScript.escape(this.str) + '\"';
        }
    }
}

