/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionalDashboardStateStoreImpl
implements DashboardStateStore {
    private final DashboardStateStore stateStore;
    private final TransactionTemplate txTemplate;

    @Autowired
    public TransactionalDashboardStateStoreImpl(@ComponentImport DashboardStateStore stateStore, @ComponentImport TransactionTemplate txTemplate) {
        this.stateStore = (DashboardStateStore)Preconditions.checkNotNull((Object)stateStore, (Object)"stateStore");
        this.txTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)txTemplate, (Object)"txTemplate");
    }

    public DashboardState retrieve(final DashboardId dashboardId) throws DashboardNotFoundException {
        Preconditions.checkNotNull((Object)dashboardId, (Object)"dashboardId");
        return (DashboardState)this.txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return TransactionalDashboardStateStoreImpl.this.stateStore.retrieve(dashboardId);
            }
        });
    }

    public DashboardState update(final DashboardState state, final Iterable<DashboardChange> changes) throws DashboardStateStoreException {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        Preconditions.checkNotNull(changes, (Object)"changes");
        return (DashboardState)this.txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return TransactionalDashboardStateStoreImpl.this.stateStore.update(state, changes);
            }
        });
    }

    public void remove(final DashboardId dashboardId) throws DashboardStateStoreException {
        Preconditions.checkNotNull((Object)dashboardId, (Object)"dashboardId");
        this.txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                TransactionalDashboardStateStoreImpl.this.stateStore.remove(dashboardId);
                return null;
            }
        });
    }

    public DashboardState findDashboardWithGadget(final GadgetId gadgetId) throws DashboardNotFoundException {
        Preconditions.checkNotNull((Object)gadgetId, (Object)"gadgetId");
        return (DashboardState)this.txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return TransactionalDashboardStateStoreImpl.this.stateStore.findDashboardWithGadget(gadgetId);
            }
        });
    }
}

