/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.gadgets.dashboard.internal.impl.TransactionalDashboardStateStoreImpl;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class DashboardServiceImpl
implements DashboardService {
    private final DashboardStateStore stateStore;
    private final DashboardPermissionService permissionService;

    @Autowired
    public DashboardServiceImpl(TransactionalDashboardStateStoreImpl stateStore, @ComponentImport DashboardPermissionService permissionService) {
        this.stateStore = stateStore;
        this.permissionService = permissionService;
    }

    public DashboardState get(DashboardId id, String username) throws PermissionException {
        if (!this.permissionService.isReadableBy(id, username)) {
            throw new PermissionException();
        }
        return this.stateStore.retrieve(id);
    }

    public DashboardState save(DashboardState state, String username) throws PermissionException {
        if (!this.permissionService.isWritableBy(state.getId(), username)) {
            throw new PermissionException();
        }
        return this.stateStore.update(state, (Iterable)ImmutableList.of());
    }
}

