package com.atlassian.gadgets.plugins;

import com.atlassian.plugin.ModuleDescriptor;
import io.atlassian.fugue.Option;

/**
 * Module descriptor to represent a non-opensocial dashboard item that can be used to render a dashboard content inline
 * without iframes.
 * <p/>
 * This is the way of the future and eventually all opensocial gadget will be replaced by inline renderable dashboard
 * items.
 */
public interface DashboardItemModuleDescriptor extends ModuleDescriptor<DashboardItemModule> {
    /**
     * @return an optional gadgetspec uri to replace. If none is returned this dashbaorditem wont replace any existing
     * gadget
     */
    Option<String> getGadgetSpecUriToReplace();

    /**
     * @return return an optional description of the dashboard item. If none is provided, the dashboard item will
     * used specification from {@link #getGadgetSpecUriToReplace()}.
     */
    Option<DashboardItemModule.DirectoryDefinition> getDirectoryDefinition();

}
