package com.atlassian.gadgets.feed;

import java.net.URI;

/**
 * Exception thrown if the reader cannot connect to the host of the gadget spec feed cannot.
 */
public class GadgetFeedHostConnectionException extends RuntimeException {
    private final URI feedUri;

    public GadgetFeedHostConnectionException(String message, URI feedUri, Throwable cause) {
        super(message, cause);
        this.feedUri = feedUri;
    }

    public URI getFeedUri() {
        return feedUri;
    }
}
