package com.atlassian.gadgets;

import com.atlassian.plugin.ModuleCompleteKey;
import io.atlassian.fugue.Option;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LocalDashboardItemModuleId implements DashboardItemModuleId {
    private final ModuleCompleteKey fullModuleKey;
    private final Option<OpenSocialDashboardItemModuleId> replacedGadgetId;

    public LocalDashboardItemModuleId(final ModuleCompleteKey fullModuleKey) {
        this(fullModuleKey, Option.<OpenSocialDashboardItemModuleId>none());
    }

    public LocalDashboardItemModuleId(final ModuleCompleteKey fullModuleKey, final Option<OpenSocialDashboardItemModuleId> replacedGadgetId) {
        this.fullModuleKey = fullModuleKey;
        this.replacedGadgetId = replacedGadgetId;
    }

    @Override
    public String getId() {
        return fullModuleKey.getCompleteKey();
    }

    @Override
    public DashboardItemType getType() {
        return DashboardItemType.LOCAL_DASHBOARD_ITEM;
    }

    public ModuleCompleteKey getFullModuleKey() {
        return fullModuleKey;
    }

    public Option<OpenSocialDashboardItemModuleId> getReplacedGadgetId() {
        return replacedGadgetId;
    }

    @Override
    public <T> T accept(final DashboardItemModuleIdVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalDashboardItemModuleId)) {
            return false;
        }
        LocalDashboardItemModuleId rhs = (LocalDashboardItemModuleId) o;
        return new EqualsBuilder()
                .append(getId(), rhs.getId())
                .append(getReplacedGadgetId(), rhs.getReplacedGadgetId())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .append(getFullModuleKey())
                .append(getReplacedGadgetId())
                .toHashCode();
    }
}
