package com.atlassian.gadgets.plugins;

import java.net.URI;

import static com.atlassian.gadgets.plugins.PluginGadgetSpec.Key;

/**
 * Version 3.4 added the ability to define a custom {@link URI} location for gadget specs.
 * <p>
 * This means developers are no longer restricted to the default plugin-sensitive {@link URI} format, are free to
 * defined custom URI and move gadgets between plugins while maintaining backward compatible {@link URI}.
 * <p>
 * This service provides a mean of translating from old public-facing identifier to an internally recognisable
 * identifier.
 *
 * @since 3.4
 */
public interface GadgetLocationTranslator {
    /**
     * Translate public-facing gadget spec key to internal plugin gadget spec key.
     *
     * @param key The gadget spec key to be translated.
     * @return Either the translated key or the same given {@code key}.
     */
    Key translate(Key key);

    /**
     * Translate public-facing gadget spec URI to internal plugin gadget spec URI.
     *
     * @param uri The gadget spec uri to be translated.
     * @return Either the translated uri or the same given {@code uri}.
     */
    URI translate(URI uri);
}
