package com.atlassian.gadgets;

import io.atlassian.fugue.Option;

public enum DashboardItemType {
    LOCAL_DASHBOARD_ITEM("dashboard-item"), OPEN_SOCIAL_GADGET("gadget");

    private final String name;

    DashboardItemType(final String name) {
        this.name = name;
    }

    public static Option<DashboardItemType> forName(final String name) {
        for (DashboardItemType type : values()) {
            if (type.getName().equals(name)) {
                return Option.some(type);
            }
        }
        return Option.none();
    }

    public String getName() {
        return name;
    }
}