/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.plugins;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.util.Assertions;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginGadgetSpec {
    private final Plugin plugin;
    private final String location;
    private final String moduleKey;
    private final Map<String, String> params;

    public PluginGadgetSpec(Plugin plugin, String moduleKey, String location, Map<String, String> params) {
        this.plugin = (Plugin)Assertions.notNull((String)"plugin", (Object)plugin);
        this.moduleKey = (String)Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        this.location = (String)Assertions.notNull((String)"location", (Object)location);
        this.params = this.unmodifiableCopy((Map)Assertions.notNull((String)"params", params));
    }

    private Map<String, String> unmodifiableCopy(Map<String, String> map) {
        return Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    public Key getKey() {
        return new Key(this.plugin.getKey(), this.location);
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getPluginKey() {
        return this.plugin.getKey();
    }

    public String getLocation() {
        return this.location;
    }

    public InputStream getInputStream() {
        return this.plugin.getResourceAsStream(this.location);
    }

    public boolean isHostedExternally() {
        return this.location.startsWith("http://") || this.location.startsWith("https://");
    }

    public boolean hasParameter(String name) {
        return this.params.containsKey(name);
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.plugin == null ? 0 : this.plugin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginGadgetSpec other = (PluginGadgetSpec)obj;
        return this.plugin.equals(other.plugin) && this.location.equals(other.location);
    }

    public String toString() {
        return "PluginGadgetSpec{plugin=" + this.plugin + ", location='" + this.location + '\'' + '}';
    }

    public static final class Key {
        private final String pluginKey;
        private final String location;

        public Key(String pluginKey, String location) {
            this.pluginKey = (String)Assertions.notNull((String)"pluginKey", (Object)pluginKey);
            this.location = (String)Assertions.notNull((String)"location", (Object)location);
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.location.equals(that.location) && this.pluginKey.equals(that.pluginKey);
        }

        public int hashCode() {
            return 31 * this.pluginKey.hashCode() + this.location.hashCode();
        }

        public String toString() {
            return "Key{pluginKey='" + this.pluginKey + '\'' + ", location='" + this.location + '\'' + '}';
        }
    }
}

